
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General 
# Public License along with this library; if not, write to the 
# Free Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
# MA  02111-1307  USA

# Copyrights (C) 
# this R-port: 
#   by Diethelm Wuertz <wuertz@itp.phys.ethz.ch>
# for the code accessed (or partly included) from other R-ports:
#   R: see R's copyright and license file
#   evir: original S functions (EVIS) by Alexander McNeil <mcneil@math.ethz.ch>
#     R port by Alec Stephenson <a.stephenson@lancaster.ac.uk>
#   ismev: Original S functions by Stuart Coles <Stuart.Coles@bristol.ac.uk>
#     R port/documentation by Alec Stephenson <a.stephenson@lancaster.ac.uk>
#   evd: Alec Stephenson <alec_stephenson@hotmail.com>


# ##############################################################################
# FUNCTION:             GPD DISTRIBUTION FAMILY:
# dgpd					 Density for the Generalized Pareto DF [USE FROM EVIS]
#  pgpd					  Probability for the Generalized Pareto DF
#  qgpd					  Quantiles for the Generalized Pareto DF
#  rgpd					  Random variates for the Generalized Pareto DF
################################################################################


dgpd = 
function(x, xi = 1, mu = 0, beta = 1)
{	# A function written by Diethelm Wuertz

	# FUNCTION:
	
	# Density:
	y = (x - mu)
	if (xi == 0) {
		d = (1-exp(-y/beta))/beta }
	else {
		d = 1/beta * (1 + (xi*y)/beta)^((-1/xi) - 1) }	
	
	d[y < 0] = 0
	if (xi < 0) d[y > (-1/xi)] = 0
	
	# Return Value:
	d
}


# ------------------------------------------------------------------------------


pgpd = 
function(q, xi = 1, mu = 0, beta = 1)
{	# A function written by Diethelm Wuertz

	# FUNCTION:
	
	# Probability:
	y = (q - mu)
	if (xi == 0) {
		p = y/beta + exp(-y/beta) -1 }
	else {
		p = (1 - (1 + (xi*y)/beta)^(-1/xi)) }	
	
	p[y < 0] = 0
	if (xi < 0) p[y > (-1/xi)] = 1
	
	# Return Value:
	p
}


# ------------------------------------------------------------------------------


qgpd = 
function(p, xi = 1, mu = 0, beta = 1)
{	# A function written by Diethelm Wuertz

	# FUNCTION:
	
	# Quantiles:
	if (xi == 0) 
		q = mu - beta*log(1-p)
	else
		q = mu + (beta/xi) * ((1 - p)^( - xi) - 1)
	
	# Return Value:
	q
}


# ------------------------------------------------------------------------------


rgpd = 
function(n, xi = 1, mu = 0, beta = 1)
{	# A function written by Diethelm Wuertz

	# FUNCTION:
	
	# Random variates:
	rvs = mu + (beta/xi) * ((1 - runif(n))^( - xi) - 1)
	
	# Return Value:
	rvs
}


# ******************************************************************************

