% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-eyelogger.R
\name{eyelogger}
\alias{eyelogger}
\title{Run \code{eyeris} commands with automatic logging of R console's stdout and stderr}
\usage{
eyelogger(
  eyeris_cmd,
  log_dir = file.path(tempdir(), "eyeris_logs"),
  timestamp_format = "\%Y\%m\%d_\%H\%M\%S"
)
}
\arguments{
\item{eyeris_cmd}{An \code{eyeris} command, wrapped in \code{{}} if multiline.}

\item{log_dir}{Character path to the desired log directory. Is set to the
temporary directory given by \code{\link[=tempdir]{tempdir()}} by default.}

\item{timestamp_format}{Format string passed to \code{format(Sys.time())} for
naming the log files. Defaults to \code{"\%Y\%m\%d_\%H\%M\%S"}.}
}
\value{
The result of the evaluated \code{eyeris} command (invisibly).
}
\description{
This utility function evaluates \code{eyeris} commands while automatically
capturing and recording both standard output (\code{stdout}) and standard error
(\code{stderr}) to timestamped log files in your desired log directory.
}
\details{
Each run produces two log files:
\itemize{
\item \verb{<timestamp>.out}: records all console output
\item \verb{<timestamp>.err}: records all warnings and errors
}
}
\examples{
eyelogger({
  message("eyeris `glassbox()` completed successfully.")
  warning("eyeris `glassbox()` completed with warnings.")
  print("some eyeris-related information.")
})

eyelogger({
  glassbox(eyelink_asc_demo_dataset(), interactive_preview = FALSE)
}, log_dir = file.path(tempdir(), "eyeris_logs"))

}
