% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.eyelinkRecording}
\alias{plot.eyelinkRecording}
\title{Plot fixations and saccades for a set of trials}
\usage{
\method{plot}{eyelinkRecording}(
  x,
  trial = 1,
  show_fixations = TRUE,
  fixation_size_property = "duration",
  size_legend = ifelse(fixation_size_property == "duration", "Fixation duration [ms]",
    NA),
  show_saccades = TRUE,
  saccade_color_property = "sttime_rel",
  color_legend = ifelse(saccade_color_property == "sttime_rel", "Saccade onset [ms]", NA),
  ...
)
}
\arguments{
\item{x}{\code{\link{eyelinkRecording}} object}

\item{trial}{Trials to be plotted, could be a scalar index,
a vector of indexes, or \code{NULL} (all trials). Defaults to \code{1}.}

\item{show_fixations}{logical, whether to draw fixation as circles. Defaults to \code{TRUE}.}

\item{fixation_size_property}{Which fixation property is used as circle aesthetics. Defaults to \code{"duration"}.}

\item{size_legend}{An optional legend title, defaults to \code{"Fixation duration [ms]"}
if \code{fixation_size_property} is \code{"duration"} and to \code{NA} otherwise. In the latter case, the legend
title is unmodified (i.e., determined by ggplot).}

\item{show_saccades}{logical, whether to draw saccades as line segments. Defaults to \code{TRUE}.}

\item{saccade_color_property}{Which saccade property is used as color aesthetics. Defaults to \code{"sttime_rel"}
(onset time relative to the trial start).}

\item{color_legend}{An optional legend title, defaults to \code{"Saccade onset [ms]"}
if \code{saccade_color_property} is \code{"sttime_rel"} and to \code{NA} otherwise. In the latter case, the legend
title is unmodified (i.e., determined by ggplot).}

\item{...}{Addition parameters (unused)}
}
\value{
ggplot object
}
\description{
This is only a basic plotting utility intended primarily
for a quick visual check. Please refer to companion vignette on plotting
for details about geoms and implementing your own custom plotting routine.
}
\examples{
data(gaze)

# fixations and saccades for the first trial
plot(gaze)

# fixations for the all trials
plot(gaze, trial = NULL, show_saccades = FALSE)

# saccades for the first two trials
plot(gaze, trial = 1:2, show_fixations = FALSE)

# color codes duration of a saccade
plot(gaze, saccade_color_property = "duration")
}
