% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wb_cv.R
\name{wb_cv}
\alias{wb_cv}
\alias{wb_distr}
\title{Wild Bootstrap Critical values}
\usage{
wb_cv(data, minw = NULL, nboot = 1000, dist_rad = FALSE,
  seed = NULL)

wb_distr(data, minw = NULL, nboot = 1000, dist_rad = FALSE,
  seed = NULL)
}
\arguments{
\item{data}{A univariate or multivariate numeric ts object, data.frame or matrix.
The estimation process cannot handle NA values.}

\item{minw}{A positive integer. The minimum window size, which defaults to
\eqn{(0.01 + 1.8/\sqrt(T))*T}{(0.01 + 1.8 / \sqrtT)*T}.}

\item{nboot}{A positive integer indicating the number of bootstraps. Default is 1000 repetitions.}

\item{dist_rad}{Logical. If \code{TRUE} then  the Rademacher distribution
will be used.}

\item{seed}{An object specifying if and how the random number generator(rng)
should be initialized. Either NULL or an integer will be used in a call to
\code{set.seed} before simulation. If set, the value is save as "seed" attribute
of the returned value. The default, NULL will note change the rng state, and
return .Random.seed as the "seed" attribute.}
}
\value{
A list that contains the critical values for ADF, BADF, BSADF and GSADF
t-statistics.
}
\description{
\code{wb_cv} performs the Harvey et al. (2016) wild bootstrap re-sampling
scheme, which is asymptotically robust to non-stationary volatility, to
generate critical values for the recursive unit root tests. \code{wb_dist}
computes the distribution.
}
\details{
This approach involves applying a wild bootstrap re-sampling scheme
to construct the bootstrap analogue of the Phillips et al. (2015) test which
is asymptotically robust to non-stationary volatility.
}
\examples{
\dontrun{
# Simulate bubble processes
dta <- data.frame(psy1 = sim_psy1(n = 100), psy2 = sim_psy2(n = 100))

# Default minimum window
wb <- wb_cv(dta)

# Change the minimum window and the number of bootstraps
wb <- wb_cv(dta, nboot = 1500, minw = 20)

# Simulate distribution
wb_distr(dta)
}
}
\references{
Harvey, D. I., Leybourne, S. J., Sollis, R., & Taylor, A. M. R.
(2016). Tests for explosive financial bubbles in the presence of
non-stationary volatility. Journal of Empirical Finance, 38(Part B), 548-574.

Phillips, P. C. B., Shi, S., & Yu, J. (2015). Testing for
Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the
S&P 500. International Economic Review, 56(4), 1043-1078.
}
\seealso{
\code{\link{mc_cv}} for Monte Carlo critical values and
\code{\link{sb_cv}} for Sieve Bootstrapped critical values
}
