% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PackageOxygen.R
\name{Burr Distribution}
\alias{Burr Distribution}
\alias{dburr}
\alias{pburr}
\alias{qburr}
\alias{rburr}
\title{The Burr Distribution}
\usage{
rburr(n, a, k)

dburr(x, a, k)

pburr(q, a, k)

qburr(p, a, k)
}
\arguments{
\item{n}{a number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{a}{a parameter of the burr distribution}

\item{k}{a parameter of the burr distribution}

\item{x}{a vector of quantiles.}

\item{q}{a vector of quantiles.}

\item{p}{a vector of probabilities.}
}
\value{
dburr gives the density, pburr gives the distribution function, qburr gives the quantile function, and rburr generates random deviates.

The length of the result is determined by n for rburr, and is the maximum of the lengths of the numerical arguments for the other functions.

The numerical arguments other than n are recycled to the length of the result. Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for the Burr distribution with \eqn{a} and \eqn{k} two parameters.
}
\details{
The cumulative Burr distribution is
\deqn{
  F(x) = 1-( 1 + (x ^ a) ) ^{- k },  x >0,  a >0,  k > 0
}
}
\examples{
plot(function(x) dburr(x,3,1), 0, 5,ylab="density",
main = " burr density ")

plot(function(x) pburr(x,3,1), 0, 5,ylab="distribution function",
     main = " burr Cumulative ")

plot(function(x) qburr(x,3,1), 0, 1,ylab="quantile",
     main = " burr Quantile ")

#generate a sample of burr distribution of size n
n <- 100
x <- rburr(n, 1, 1)


}

