% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svalue.R
\name{svalue}
\alias{svalue}
\title{Surprisal Value}
\usage{
svalue(x)
}
\arguments{
\item{x}{A numeric object of MCMC values.}
}
\value{
A non-negative number.
}
\description{
The surprisal value (Greenland 2019) is the \link{pvalue} expressed in
terms of how many consecutive heads would have to be thrown on a fair coin
in a single attempt to achieve the same probability.
}
\examples{
svalue(as.numeric(0:100))
}
\references{
Greenland, S. 2019. Valid P -Values Behave Exactly as They Should:
Some Misleading Criticisms of P -Values and Their Resolution With S -Values.
The American Statistician 73(sup1): 106–114.
\url{http://doi.org/10.1080/00031305.2018.1529625}.
}
\seealso{
Other summary: 
\code{\link{lower}()},
\code{\link{pvalue}()},
\code{\link{upper}()},
\code{\link{zscore}()}
}
\concept{summary}
