/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.extratrees.AbstractBinaryTree;
import org.extratrees.Matrix;
import org.extratrees.ShuffledIterator;
import org.extratrees.TaskCutResult;

public abstract class AbstractTrees<E extends AbstractBinaryTree> {
    Matrix input;
    protected static final double zero = 1.0E-7;
    int[] tasks;
    int nTasks;
    ArrayList<E> trees;
    int numThreads = 1;
    int numRandomTaskCuts = 1;
    double probOfTaskCuts = 1.0;
    int numRandomCuts = 1;
    boolean evenCuts = false;
    ArrayList<Integer> cols;

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int n) {
        this.numThreads = n;
    }

    public int getNumRandomTaskCuts() {
        return this.numRandomTaskCuts;
    }

    public void setNumRandomTaskCuts(int n) {
        this.numRandomTaskCuts = n;
    }

    public double getProbOfTaskCuts() {
        return this.probOfTaskCuts;
    }

    public void setProbOfTaskCuts(double d) {
        this.probOfTaskCuts = d;
    }

    public int getNumTrees() {
        return this.trees.size();
    }

    public boolean isEvenCuts() {
        return this.evenCuts;
    }

    public void setEvenCuts(boolean bl) {
        this.evenCuts = bl;
    }

    public int getNumRandomCuts() {
        return this.numRandomCuts;
    }

    public void setNumRandomCuts(int n) {
        this.numRandomCuts = n;
    }

    public void setTasks(int[] nArray) {
        this.tasks = nArray;
        this.nTasks = 1;
        if (this.tasks != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (this.nTasks >= nArray[i] + 1) continue;
                this.nTasks = nArray[i] + 1;
            }
        }
    }

    protected double getRandomCut(double d, double d2, int n) {
        double d3;
        if (this.evenCuts) {
            double d4 = d + (double)n * d2 / (double)this.numRandomCuts;
            double d5 = d + (double)(n + 1) * d2 / (double)this.numRandomCuts;
            d3 = this.getRandom() * (d5 - d4) + d4;
        } else {
            d3 = this.getRandom() * d2 + d;
        }
        return d3;
    }

    protected double[] getRange(int[] nArray, int n, Matrix matrix) {
        double[] dArray = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < nArray.length; ++i) {
            double d = matrix.get(nArray[i], n);
            if (d < dArray[0]) {
                dArray[0] = d;
            }
            if (!(d > dArray[1])) continue;
            dArray[1] = d;
        }
        return dArray;
    }

    protected double[] getRange(double[] dArray) {
        double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < dArray2[0]) {
                dArray2[0] = dArray[i];
            }
            if (!(dArray[i] > dArray2[1])) continue;
            dArray2[1] = dArray[i];
        }
        return dArray2;
    }

    public abstract E makeLeaf(int[] var1, Set<Integer> var2);

    public ArrayList<E> buildTreesParallel(int n, int n2, int n3) {
        List list;
        ExecutorService executorService = Executors.newFixedThreadPool(this.numThreads);
        ArrayList<TreeCallable> arrayList = new ArrayList<TreeCallable>();
        TreeCallable treeCallable = new TreeCallable(n, n2);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(treeCallable);
        }
        try {
            list = executorService.invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        ArrayList arrayList2 = new ArrayList(n3);
        for (Future future : list) {
            try {
                arrayList2.add(future.get());
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        executorService.shutdown();
        return arrayList2;
    }

    public ArrayList<E> buildTrees(int n, int n2, int n3) {
        ArrayList<E> arrayList = new ArrayList<E>(n3);
        for (int i = 0; i < n3; ++i) {
            arrayList.add(this.buildTree(n, n2));
        }
        return arrayList;
    }

    public void learnTrees(int n, int n2, int n3) {
        this.trees = this.numThreads <= 1 ? this.buildTrees(n, n2, n3) : this.buildTreesParallel(n, n2, n3);
    }

    public E buildTree(int n, int n2) {
        int[] nArray = new int[this.input.nrows];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        ShuffledIterator<Integer> shuffledIterator = new ShuffledIterator<Integer>(this.cols);
        HashSet<Integer> hashSet = AbstractTrees.getSequenceSet(this.nTasks);
        return this.buildTree(n, n2, nArray, shuffledIterator, hashSet);
    }

    protected abstract void calculateCutScore(int[] var1, int var2, double var3, CutResult var5);

    protected abstract TaskCutResult getTaskCut(int[] var1, Set<Integer> var2, double var3);

    public static int[][] splitIds(Matrix matrix, int[] nArray, int n, double d) {
        int n2;
        int[][] nArrayArray = new int[2][];
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (!(matrix.get(nArray[n2], n) < d)) continue;
            ++n3;
        }
        nArrayArray[0] = new int[n3];
        nArrayArray[1] = new int[nArray.length - n3];
        n2 = 0;
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (matrix.get(nArray[i], n) < d) {
                nArrayArray[0][n2] = nArray[i];
                ++n2;
                continue;
            }
            nArrayArray[1][n4] = nArray[i];
            ++n4;
        }
        return nArrayArray;
    }

    public int[][] splitIdsByTask(int[] nArray, Set<Integer> set) {
        int n;
        int[][] nArrayArray = new int[2][];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (!set.contains(this.tasks[nArray[n]])) continue;
            ++n2;
        }
        nArrayArray[0] = new int[n2];
        nArrayArray[1] = new int[nArray.length - n2];
        n = 0;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (set.contains(this.tasks[nArray[i]])) {
                nArrayArray[0][n] = nArray[i];
                ++n;
                continue;
            }
            nArrayArray[1][n3] = nArray[i];
            ++n3;
        }
        return nArrayArray;
    }

    public static int sum(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public static HashSet<Integer> getSequenceSet(int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(i);
        }
        return hashSet;
    }

    protected double getRandom() {
        return Math.random();
    }

    protected double getRandom(double d, double d2) {
        return d + this.getRandom() * (d2 - d);
    }

    protected abstract E makeFilledTree(E var1, E var2, int var3, double var4, int var6);

    public E buildTree(int n, int n2, int[] nArray, ShuffledIterator<Integer> shuffledIterator, Set<Integer> set) {
        Set<Integer> set2;
        Set<Integer> set3;
        int[][] nArray2;
        CutResult cutResult;
        Object[] objectArray;
        if (nArray.length < n) {
            return this.makeLeaf(nArray, set);
        }
        shuffledIterator.reset();
        int n3 = 0;
        int n4 = -1;
        double d = Double.NaN;
        CutResult cutResult2 = new CutResult();
        cutResult2.score = Double.POSITIVE_INFINITY;
        while (shuffledIterator.hasNext()) {
            int n5 = shuffledIterator.next();
            objectArray = this.getRange(nArray, n5, this.input);
            if (objectArray[1] - objectArray[0] < 1.0E-7) continue;
            int n6 = objectArray[1] - objectArray[0];
            for (int i = 0; i < this.numRandomCuts; ++i) {
                double d2 = this.getRandomCut(objectArray[0], n6, i);
                cutResult = new CutResult();
                this.calculateCutScore(nArray, n5, d2, cutResult);
                if (!(cutResult.score < cutResult2.score)) continue;
                n4 = n5;
                d = d2;
                cutResult2.score = cutResult.score;
                cutResult2.leftConst = cutResult.leftConst;
                cutResult2.rightConst = cutResult.rightConst;
                cutResult2.countLeft = cutResult.countLeft;
                cutResult2.countRight = cutResult.countRight;
            }
            if (++n3 < n2) continue;
            break;
        }
        TaskCutResult taskCutResult = null;
        if (set.size() > 1 && this.probOfTaskCuts > this.getRandom()) {
            taskCutResult = this.getTaskCut(nArray, set, cutResult2.score);
        }
        objectArray = new int[cutResult2.countLeft];
        int[] nArray3 = new int[cutResult2.countRight];
        if (n4 < 0 && taskCutResult == null) {
            return this.makeLeaf(nArray, set);
        }
        if (taskCutResult != null) {
            nArray2 = this.splitIdsByTask(nArray, taskCutResult.leftTasks);
            set3 = taskCutResult.leftTasks;
            set2 = taskCutResult.rightTasks;
            n4 = -1;
            d = Double.NaN;
        } else {
            nArray2 = AbstractTrees.splitIds(this.input, nArray, n4, d);
            set3 = set;
            set2 = set;
        }
        objectArray = nArray2[0];
        nArray3 = nArray2[1];
        E e = cutResult2.leftConst ? this.makeLeaf((int[])objectArray, set3) : this.buildTree(n, n2, (int[])objectArray, shuffledIterator, set3);
        cutResult = cutResult2.rightConst ? this.makeLeaf(nArray3, set2) : this.buildTree(n, n2, nArray3, shuffledIterator, set2);
        CutResult cutResult3 = this.makeFilledTree(e, cutResult, n4, d, nArray.length);
        ((AbstractBinaryTree)((Object)cutResult3)).tasks = set;
        return (E)cutResult3;
    }

    public class TreeCallable
    implements Callable<E> {
        int nmin;
        int K;

        public TreeCallable(int n, int n2) {
            this.nmin = n;
            this.K = n2;
        }

        @Override
        public E call() throws Exception {
            return AbstractTrees.this.buildTree(this.nmin, this.K);
        }
    }

    protected static class CutResult {
        double score;
        boolean leftConst;
        boolean rightConst;
        int countLeft;
        int countRight;
        Object value;

        public int getCountLeft() {
            return this.countLeft;
        }

        public void setCountLeft(int n) {
            this.countLeft = n;
        }

        public int getCountRight() {
            return this.countRight;
        }

        public void setCountRight(int n) {
            this.countRight = n;
        }

        public boolean isLeftConstant() {
            return this.leftConst;
        }

        public void setLeftConstant(boolean bl) {
            this.leftConst = bl;
        }

        public boolean isRightConstant() {
            return this.rightConst;
        }

        public void setRightConstant(boolean bl) {
            this.rightConst = bl;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double d) {
            this.score = d;
        }
    }
}

