% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_size_calculation.R
\name{effsize}
\alias{effsize}
\title{Effect size calculation}
\usage{
effsize(matrices_obj)
}
\arguments{
\item{matrices_obj}{List of 2 matrices, named mean.mat and sd.mat. This is the minimal output of the \code{calculate_mean_matrix} function. The full output from \code{calculate_mean_matrix} is also valid.}
}
\value{
Vector of length 3. The first two elements are the effect sizes for the main effects factor A and factor B,
respectively. The third element is the interaction effect size.
}
\description{
Calculate effect sizes for two-way factorial designs from matrices of expected mean and standard deviation values
at each combination of factor levels. The output given is Cohen's f. Calculations are done as exemplified in the
G*Power 3.1 manual.
}
\examples{

# no interaction effect expected
refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85

factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)

effects_treat_time <- calculate_mean_matrix(refmean = refmean,
                                            nlfA = treatgroups, nlfB = timepoints,
                                            fAeffect = treateff, fBeffect = timeeff,
                                            label_list = factors_levels_names)
effsize(effects_treat_time)

# we add cell specific interaction effect keeping design and main effect coefficients
cellswithinteraction <- matrix(c(rep(2,3), 3:5), 3,2)
#second level of factor A interacts with 3rd, 4th and 5th level of factor B

effects_treat_time_interact <- calculate_mean_matrix(refmean = refmean,
                                                     nlfA = treatgroups, nlfB = timepoints,
                                                     fAeffect = treateff, fBeffect = timeeff,
                                                     label_list = factors_levels_names,
                                                     groupswinteraction = cellswithinteraction,
                                                     interact=1.3)
effsize(effects_treat_time_interact)


}
