% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate}
\alias{aggregate}
\title{Aggregate an \code{expstudy}}
\usage{
aggregate(expstudy, ..., .oth_sum_vars = NULL)
}
\arguments{
\item{expstudy}{an \code{\link[=expstudy]{expstudy()}}}

\item{...}{variables to use as groups}

\item{.oth_sum_vars}{additional variable to total. Multiple variables can be provided using
\code{\link[=c]{c()}}.}
}
\value{
an aggregated \code{expstudy}.
}
\description{
Often an \code{expstudy} needs to be aggregated according to different variables
for analysis. This function provides easy aggregation of the \code{expstudy}
metric variables \code{exposures}, \code{expected}, and \code{actuals}.

Grouping can be performed by passing variables as unnamed arguments. If no
groups are specified, the grand total of the \code{expstudy} metric variables will
be returned.

By default, only the metric variables are summed and returned. Other
variables can also be totaled by using the \code{.oth_sum_vars} to specify.
}
\examples{
  es <- expstudy(
    data = mortexp,
    actuals = ACTUAL_DEATHS,
    expecteds = EXPECTED_DEATHS,
    exposures =  EXPOSURE,
    variances = VARIANCE_DEATHS
  )

  es \%>\%
    aggregate(ATTAINED_AGE)

  es \%>\%
    aggregate(
      GENDER,
      UNDERWRITING_CLASS,
      SMOKING_STATUS
    )

}
