% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{print.plot_expirest_osle}
\alias{print.plot_expirest_osle}
\title{Print a plot illustrating the shelf life estimation (osle)}
\usage{
\method{print}{plot_expirest_osle}(x, ...)
}
\arguments{
\item{x}{An object of class \sQuote{\code{plot_expirest_osle}} returned by
the \code{\link{plot_expirest_osle}()} function.}

\item{...}{Further arguments passed to or from other methods or arguments
that can be passed down to the \code{\link[base]{formatC}()} function.}
}
\value{
The \sQuote{\code{plot_expirest_osle}} object passed to the \code{x}
parameter is returned invisibly.
}
\description{
This is a method for the function \code{print()} for objects of class
\sQuote{\code{plot_expirest_osle}}.
}
\details{
The element \code{Graph} of the \sQuote{\code{plot_expirest_osle}}
object that is returned by the function \code{\link{plot_expirest_osle}()}
is an object of class \sQuote{\code{ggplot}}, generated by the function
\code{\link[ggplot2]{ggplot}()} from the \sQuote{\code{ggplot2}} package.
Thus, the corresponding \code{plot} method is used for plotting. Arguments
to the \code{\link[ggplot2]{ggplot}()} function can be passed via the
\code{...} parameter.
}
\examples{
# Potency stability data (in \% of label claim (LC)) of five batches of a drug
# product obtained over a 24 months period:
str(exp1)

# 'data.frame':	53 obs. of  3 variables:
# $ Batch  : Factor w/ 6 levels "b2","b3","b4",..: 1 1 1 1 1 1 1 1 1 1 ...
# $ Month  : num  0 1 3 3 6 6 12 12 24 24 ...
# $ Potency: num  101 101.3 99.8 99.2 99.5 ...

# Performing an "ordinary shelf life estimation" (osle)
res1 <-
  expirest_osle(data = exp1[exp1$Batch \%in\% c("b2", "b5", "b7"), ],
                response_vbl = "Potency", time_vbl = "Month",
                batch_vbl = "Batch", sl = 95, sl_sf = 3, srch_range = c(0, 500))

# The 'expirest_osle' object can be passed on to the plot_expirest_osle()
# function. This function does not produce any output but returns a
# 'plot_expirest_osle' object.
gg1 <- plot_expirest_osle(
  model = res1, show_grouping = "no", response_vbl_unit = "\%",
  y_range = c(93, 107), x_range = NULL, plot_option = "full",
  ci_app = "line")
gg2 <- print(gg1)

# The print() function returns the 'plot_expirest_osle' object invisibly.
class(gg1)
class(gg2)
}
\seealso{
\code{\link{expirest_osle}}, \code{\link{plot_expirest_osle}},
\code{\link[ggplot2]{ggplot}()}, \code{\link[utils]{methods}}.
}
