# Test all of the check_*(), mark_*(), and exclude_*() functions

test_that("Output class is same as input class", {
  expect_s3_class(check_duplicates(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(check_duration(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(check_ip(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(check_location(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(check_preview(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(check_progress(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(check_resolution(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_duplicates(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_duration(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_ip(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_location(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_preview(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_progress(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  expect_s3_class(mark_resolution(qualtrics_numeric, quiet = TRUE), class(qualtrics_numeric))
  suppressMessages(expect_s3_class(exclude_duplicates(qualtrics_numeric), class(qualtrics_numeric)))
  suppressMessages(expect_s3_class(exclude_duration(qualtrics_numeric), class(qualtrics_numeric)))
  suppressMessages(expect_s3_class(exclude_ip(qualtrics_numeric), class(qualtrics_numeric)))
  suppressMessages(expect_s3_class(exclude_location(qualtrics_numeric), class(qualtrics_numeric)))
  suppressMessages(expect_s3_class(exclude_preview(qualtrics_numeric), class(qualtrics_numeric)))
  suppressMessages(expect_s3_class(exclude_progress(qualtrics_numeric), class(qualtrics_numeric)))
  suppressMessages(expect_s3_class(exclude_resolution(qualtrics_numeric), class(qualtrics_numeric)))
})

test_that("Messages displayed by default", {
  suppressMessages(expect_message(check_duplicates(qualtrics_numeric)))
  suppressMessages(expect_message(check_duration(qualtrics_numeric)))
  suppressMessages(expect_message(check_ip(qualtrics_numeric)))
  suppressMessages(expect_message(check_location(qualtrics_numeric)))
  suppressMessages(expect_message(check_preview(qualtrics_numeric)))
  suppressMessages(expect_message(check_progress(qualtrics_numeric)))
  suppressMessages(expect_message(check_resolution(qualtrics_numeric)))
  suppressMessages(expect_message(mark_duplicates(qualtrics_numeric)))
  suppressMessages(expect_message(mark_duration(qualtrics_numeric)))
  suppressMessages(expect_message(mark_ip(qualtrics_numeric)))
  suppressMessages(expect_message(mark_location(qualtrics_numeric)))
  suppressMessages(expect_message(mark_preview(qualtrics_numeric)))
  suppressMessages(expect_message(mark_progress(qualtrics_numeric)))
  suppressMessages(expect_message(mark_resolution(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_duplicates(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_duration(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_ip(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_location(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_preview(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_progress(qualtrics_numeric)))
  suppressMessages(expect_message(exclude_resolution(qualtrics_numeric)))
})

test_that("No messages displayed when quiet = TRUE", {
  expect_message(check_duplicates(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_duration(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_ip(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_location(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_preview(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_progress(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_resolution(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(check_resolution(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_duplicates(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_duration(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_ip(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_location(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_preview(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_progress(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_resolution(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(mark_resolution(qualtrics_numeric, quiet = TRUE), NA)
  expect_message(exclude_duplicates(qualtrics_numeric, silent = TRUE), NA)
  expect_message(exclude_duration(qualtrics_numeric, silent = TRUE), NA)
  expect_message(exclude_ip(qualtrics_numeric, silent = TRUE), NA)
  expect_message(exclude_location(qualtrics_numeric, silent = TRUE), NA)
  expect_message(exclude_preview(qualtrics_numeric, silent = TRUE), NA)
  expect_message(exclude_progress(qualtrics_numeric, silent = TRUE), NA)
  expect_message(exclude_resolution(qualtrics_numeric, silent = TRUE), NA)
})
