% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{mark_preview}
\alias{mark_preview}
\title{Mark survey previews}
\usage{
mark_preview(
  x,
  id_col = "ResponseId",
  preview_col = "Status",
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{preview_col}{Column name for survey preview.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
An object of the same type as \code{x} that includes a column marking rows
that are survey previews.
For a function that checks for these rows, use \code{\link[=check_preview]{check_preview()}}.
For a function that excludes these rows, use \code{\link[=exclude_preview]{exclude_preview()}}.
}
\description{
The \code{mark_preview()} function creates a column labeling
rows that are survey previews.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The preview column in Qualtrics can be a numeric or character vector
depending on whether it is exported as choice text or numeric values.
This function works for both.

The function outputs to console a message about the number of rows
that are survey previews.
}
\examples{
# Mark survey previews
data(qualtrics_text)
df <- mark_preview(qualtrics_text)

# Works for Qualtrics data exported as numeric values, too
df <- qualtrics_numeric \%>\%
  mark_preview()
}
\seealso{
Other preview functions: 
\code{\link{check_preview}()},
\code{\link{exclude_preview}()}

Other mark functions: 
\code{\link{mark_duplicates}()},
\code{\link{mark_duration}()},
\code{\link{mark_ip}()},
\code{\link{mark_location}()},
\code{\link{mark_progress}()},
\code{\link{mark_resolution}()}
}
\concept{mark functions}
\concept{preview functions}
