% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data.R
\name{extract_data}
\alias{extract_data}
\title{Extract Data From a Report}
\usage{
extract_data(
  .df,
  checkcol = NA,
  promote_colnames = TRUE,
  strip_na_greater_than = 0.2
)
}
\arguments{
\item{.df}{a data frame object.}

\item{checkcol}{numeric. (optional). The column number to check for NA values.
If not specified, extract_data will attempt to guess the appropriate column.}

\item{promote_colnames}{logical. (optional). Should the first row be promoted
to column names?}

\item{strip_na_greater_than}{double between 0 - 1. Drops rows with greater than this percentage of missing values. Defaults to 0.2}
}
\value{
a data frame object.
}
\description{
Extract Data From a Report
}
\examples{
\dontrun{
df <- readxl::read_excel("man/example/example-report.xlsx")
extract_data(df)
}

}
