% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_TestItemFunctions.R
\name{ItemOdds}
\alias{ItemOdds}
\title{Item Odds}
\usage{
ItemOdds(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
A numeric vector of odds values for each item. Values range from 0 to infinity,
where:
\itemize{
\item odds > 1: correct response more likely than incorrect
\item odds = 1: equally likely
\item odds < 1: incorrect response more likely than correct
}
}
\description{
Item Odds are defined as the ratio of Correct Response Rate to
Incorrect Response Rate:
\deqn{O_j = \frac{p_j}{1-p_j}}
where \eqn{p_j} is the correct response rate for item j.
This function is applicable only to binary response data.

The odds value represents how many times more likely a correct response is
compared to an incorrect response. For example, an odds of 2 means students
are twice as likely to answer correctly as incorrectly.
}
\note{
This function is implemented using a binary data compatibility wrapper and
will raise an error if used with polytomous data.
}
\examples{
# using sample dataset
ItemOdds(J5S10)
}
