% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{n1.get.vector}
\alias{n1.get.vector}
\title{Find minimal n1 achieving target power for all values of n0}
\usage{
n1.get.vector(data, beta, p0, delta, alpha, type = 1)
}
\arguments{
\item{data}{power database for selected value of alpha and delta (See
details)}

\item{beta}{scalar target for power}

\item{p0}{scalar value of baseline probability}

\item{delta}{value of clinically relevant difference}

\item{alpha}{value of nominal size of test}

\item{type}{type of minimum solution (See details)}
}
\value{
a list with element x (giving range of values of n0) and y (giving
minimal solutions for n1 of power > beta). integer indicates
}
\description{
For values of n0 covered in the matrix data (typically from 20 to 500) the
function calls n1.get and finds the minimal value of n1 achieving the target
power.
}
\details{
This function is called by n1.get.solution and will likely never be run by
the user.

The data matrix will be one of the 85 main databases.

If type=1, the smallest value N1 of n1 so that power > beta is returned. If
type=2, the smallest value N1 of n1 so that power > beta for all n1>=N1 is
returned.
}
\references{
C.J. Lloyd & R. Ripamonti (2021) A comprehensive open-source
library for exact required sample size in binary clinical trials.
Contemporary Clinical Trials 107. \doi{10.1016/j.cct.2021.106491}
}
\author{
Chris J. Lloyd
}
\keyword{internal}
\keyword{~design}
\keyword{~htest}
