% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolvabilityBeta.R
\name{evolvabilityBeta}
\alias{evolvabilityBeta}
\title{Calculate evolvability parameters along a set of selection gradients}
\usage{
evolvabilityBeta(G, Beta, means = 1)
}
\arguments{
\item{G}{A variance matrix.}

\item{Beta}{Either a vector or a matrix of unit length selection gradients
stacked column wise.}

\item{means}{An optional vector of trait means (for internal mean
standardization).}
}
\value{
An object of \code{class} \code{'evolvabilityBeta'}, which is a list
with the following components:
\tabular{llllll}{
\code{Beta} \tab\tab\tab\tab The matrix of selection gradients. \cr
\code{e} \tab\tab\tab\tab The evolvability of each selection gradient. \cr
\code{r} \tab\tab\tab\tab The respondability of each selection gradient. \cr
\code{c} \tab\tab\tab\tab The conditional evolvability of each selection
gradient. \cr
\code{a} \tab\tab\tab\tab The autonomy of each selection gradient. \cr
\code{i} \tab\tab\tab\tab The integration of each selection gradient.
}
}
\description{
\code{G} needs to be symmetric and positive definite.
}
\details{
\code{evolvabilityBeta} calculates (unconditional) evolvability (e),
respondability (r), conditional evolvability (c), autonomy (a) and
integration (i) along selection gradients given an additive-genetic variance
matrix as described in Hansen and Houle (2008).
}
\examples{
G <- matrix(c(1, 1, 0, 1, 2, 2, 0, 2, 3), ncol = 3) / 10
Beta <- randomBeta(5, 3)
X <- evolvabilityBeta(G, Beta)
summary(X)
}
\references{
Hansen, T. F. & Houle, D. (2008) Measuring and comparing
evolvability and constraint in multivariate characters. J. Evol. Biol.
21:1201-1219.
}
\author{
Geir H. Bolstad
}
\keyword{algebra}
\keyword{array}
