% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCScoreCorrelation.R
\name{PCScoreCorrelation}
\alias{PCScoreCorrelation}
\title{PC Score Correlation Test}
\usage{
PCScoreCorrelation(means, cov.matrix, taxons = names(means),
  show.plots = FALSE)
}
\arguments{
\item{means}{list or array of species means being compared. array must have means in the rows.}

\item{cov.matrix}{ancestral covariance matrix for all populations}

\item{taxons}{names of taxons being compared. Must be in the same order of the means.}

\item{show.plots}{boolean. If TRUE, plot of eigenvalues of ancetral matrix by between group variance is showed.}
}
\value{
list of results containing:

correlation matrix of principal component scores and p.values for each correlation. Lower triangle of outputput are correlations, and upper triangle are p.values.

if show.plots is TRUE, also returns a list of plots of all projections of the nth PCs, where n is the number of taxons.
}
\description{
Given a set of covariance matrices and means for terminals, test the hypothesis
that obseved divergency is larger/smaller than expected by drift alone using the correlation on
principal component scores.
}
\examples{
#Input can be an array with means in each row or a list of mean vectors
means = array(rnorm(40*10), c(10, 40)) 
cov.matrix = RandomMatrix(40, 1, 1, 10)
taxons = LETTERS[1:10]
PCScoreCorrelation(means, cov.matrix, taxons)

##Plots list can be displayed using grid.arrange()
#library(gridExtra)
#pc.score.output <- PCScoreCorrelation(means, cov.matrix, taxons, TRUE)
#do.call(grid.arrange, c(pc.score.output$plots,list(nrow=4,ncol=6)))
##Or we can print to file:
#ggsave("multipage.pdf", do.call(marrangeGrob, c(pc.score.output$plots, list(nrow=2, ncol=2))))
}
\author{
Ana Paula Assis, Diogo Melo
}
\references{
Marroig, G., and Cheverud, J. M. (2004). Did natural selection or genetic drift 
produce the cranial diversification of neotropical monkeys? The American Naturalist, 163(3), 417-428. doi:10.1086/381693
}

