---
output: github_document
---

eurostat R package
======

<!--[![Stories in Ready](http://badge.waffle.io/ropengov/eurostat.png?label=TODO)](http://waffle.io/ropengov/eurostat)-->
<!--[![CRAN version](http://www.r-pkg.org/badges/version/eurostat)](https://cran.r-project.org/package=eurostat)-->
[![Build Status](https://travis-ci.org/rOpenGov/eurostat.svg?branch=master)](https://travis-ci.org/rOpenGov/eurostat)
[![codecov.io](https://codecov.io/github/rOpenGov/eurostat/coverage.svg?branch=master)](https://codecov.io/github/rOpenGov/eurostat?branch=master)
[![Downloads](http://cranlogs.r-pkg.org/badges/grand-total/eurostat)](https://cran.r-project.org/package=eurostat)
[![Downloads](http://cranlogs.r-pkg.org/badges/eurostat)](https://cran.r-project.org/package=eurostat)
[![Follow](https://img.shields.io/twitter/follow/ropengov.svg?style=social)](https://twitter.com/intent/follow?screen_name=ropengov)
<!--[![License](https://img.shields.io/pypi/l/Django.svg)](https://opensource.org/licenses/BSD-2-Clause)-->
[![Gitter](https://badges.gitter.im/rOpenGov/eurostat.svg)](https://gitter.im/rOpenGov/eurostat?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)

<!-- README.md is generated from README.Rmd. Please edit that file -->



R tools to access open data from [Eurostat](http://ec.europa.eu/eurostat). Data search, download, manipulation and visualization. 


### Installation and use

To install the CRAN release version, use:


```r
install.packages("eurostat")
```


For the latest github development version, use:


```r
install_github("ropengov/eurostat")
```



See the the [package homepage](http://ropengov.github.io/eurostat) with links to [function documentation](http://ropengov.github.io/eurostat/reference/index.html) and [tutorials](http://ropengov.github.io/eurostat/articles/index.html) as well as contact details. The [manuscript](https://github.com/rOpenGov/eurostat/blob/master/vignettes/2017_RJournal_manuscript/RJwrapper.pdf) submitted to R Journal provides a generic overview of the package functionality.

<!--
 * [Eurostat R Cheat Sheet](https://github.com/rOpenGov/eurostat/blob/master/vignettes/cheatsheet/eurostat_cheatsheet.pdf)
 * [Package vignette](https://github.com/rOpenGov/eurostat/blob/master/vignettes/eurostat_tutorial.md) for installation and standard use
 * Blog posts ([package release](https://rpubs.com/muuankarski/27120) / [case studies](http://ropengov.github.io/r/2015/05/01/eurostat-package-examples/))  
 * Journal manuscript ([markdown](https://github.com/rOpenGov/eurostat/blob/master/vignettes/2017_RJournal_manuscript/lahti-huovari-kainu-biecek.md) / [pdf](https://github.com/rOpenGov/eurostat/blob/master/vignettes/2017_RJournal_manuscript/RJwrapper.pdf)) with reproducible examples
-->

### Contribute

Contributions are very welcome:

  * [Use issue tracker](https://github.com/ropengov/eurostat/issues) for feedback and bug reports.
  * [Send pull requests](https://github.com/ropengov/eurostat/)
  * [Star us on the Github page](https://github.com/ropengov/eurostat)
  * [Join the discussion in Gitter](https://gitter.im/rOpenGov/eurostat)

### Acknowledgements

**Kindly cite this work** as follows: [Leo Lahti](https://github.com/antagomir), Przemyslaw Biecek, Markus Kainu and Janne Huovari. Retrieval and analysis of Eurostat open data with the eurostat package. Accepted for publication in R Journal 2017. R package version 3.1.1. URL: [http://ropengov.github.io/eurostat](http://ropengov.github.io/eurostat)

We are greatful to all [contributors](https://github.com/rOpenGov/eurostat/graphs/contributors), including Joona Lehtomäki, Francois Briatte, and Oliver Reiter, and for the [Eurostat](http://ec.europa.eu/eurostat/) open data portal! This project is part of [rOpenGov](http://ropengov.github.io).





### Disclaimer

This package is in no way officially related to or endorsed by Eurostat.



