% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market.R
\name{etrd_option_expiration}
\alias{etrd_option_expiration}
\title{Option Expiration Dates}
\usage{
etrd_option_expiration(
  symbol = "SPY",
  output = c("df", "list"),
  access_tokens = NULL,
  etrade_cred = NULL,
  sandbox = FALSE
)
}
\arguments{
\item{symbol}{The symbol in the request}

\item{output}{Indicate whether the output should be in the form of a data
frame ('df') or list ('list'). Data frame is returned by default.}

\item{access_tokens}{Access tokens are created using
\code{\link{etrd_auth_access_token}}. This entry is not required because
the output is saved and retrieved from R options automatically.}

\item{etrade_cred}{The output created from
\code{\link{etrd_auth_credentials}} when a valid ETRADE key and secret have
been passed. This entry is not required because the output is saved and
retrieved from R options automatically.}

\item{sandbox}{ETRADE offers a sandbox environment for validating API calls
and responses. If using the sandbox environment, this must be set to TRUE
in each function called throughout etrader. ETRADE states "Sandbox
responses use stored data that's intended to provide typical responses for
basic use cases. So the responses you receive will not contain current
data, and may not exactly match your requests in other ways." Essentially,
the responses will not match the requests entered but successful pull will
indicate whether the entry was valid or not.}
}
\value{
a data frame of expiration dates for the symbol requested
}
\description{
Returns a list or data frame of dates suitable for structuring an option
table display. The dates are used to group option data (returned by the
option chains method) for a specified underlier, creating a table display.
}
\examples{
\dontrun{

# Get SPY Expirations
etrd_option_expiration('SPY')

}
}
