% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etl_extract.R
\name{smart_download}
\alias{smart_download}
\title{Download only those files that don't already exist}
\usage{
smart_download(obj, src, new_filenames = basename(src), clobber = FALSE, ...)
}
\arguments{
\item{obj}{an \code{\link{etl}} object}

\item{src}{a character vector of URLs that you want to download}

\item{new_filenames}{an optional character vector of filenames for the new
(local) files. Defaults to having the same filenames as those in \code{src}.}

\item{clobber}{do you want to clobber any existing files?}

\item{...}{arguments passed to \code{\link[downloader]{download}}}
}
\description{
Download only those files that don't already exist
}
\details{
Downloads only those files in \code{src} that are not already present in
the directory specified by the \code{raw_dir} attribute of \code{obj}.
}
\examples{
cars <- etl("mtcars")
urls <- c("https://raw.githubusercontent.com/beanumber/etl/master/etl.Rproj",
"https://www.reddit.com/robots.txt")
smart_download(cars, src = urls)
# won't download again if the files are already there
smart_download(cars, src = urls)
# use clobber to overwrite
smart_download(cars, src = urls, clobber = TRUE)
}
\author{
idiom courtesy of Hadley Wickham
}
