% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-chooseData.R
\name{chooseData-module}
\alias{chooseData-module}
\alias{chooseDataUI}
\alias{chooseDataServer}
\title{Module for choosing data.frame}
\usage{
chooseDataUI(id, label = "Choose data", icon = "database")

chooseDataServer(input, output, session, dataModule = c("GlobalEnv",
  "ImportFile"), data = NULL, name = NULL, selectVars = TRUE,
  coerceVars = FALSE, launchOnStart = TRUE, size = "m")
}
\arguments{
\item{id}{Module's id.}

\item{label}{Button's label.}

\item{icon}{Button's icon.}

\item{input}{Standard \code{shiny} input.}

\item{output}{Standard \code{shiny} output.}

\item{session}{Standard \code{shiny} session.}

\item{dataModule}{Data module to use, choose between \code{"GlobalEnv"}
or \code{"ImportFile"}.}

\item{data}{A \code{data.frame} to use by default.}

\item{name}{Character, object's name to use for \code{data}.}

\item{selectVars}{Display module to select variables, \code{TRUE} by default.}

\item{coerceVars}{Display module to coerce variables between different class, \code{TRUE} by default.}

\item{launchOnStart}{Opens modal window when the application starts.}

\item{size}{Size for the modal window.}
}
\value{
a \code{\link[shiny]{reactiveValues}} containing the data selected under slot \code{data}
and the name of the selected \code{data.frame} under slot \code{name}.
}
\description{
Module for choosing data.frame from
user environment and select variable to use.
}
\examples{

if (interactive()) {


library(shiny)
library(esquisse)

ui <- fluidPage(
  tags$h2("Choose data module"),
  fluidRow(
    column(
      width = 4,
      tags$h4("Default"),
      chooseDataUI(id = "choose1"),
      verbatimTextOutput(outputId = "res1")
    ),
    column(
      width = 4,
      tags$h4("No var selection"),
      chooseDataUI(id = "choose2"),
      verbatimTextOutput(outputId = "res2")
    ),
    column(
      width = 4,
      tags$h4("Default data on start"),
      chooseDataUI(id = "choose3"),
      verbatimTextOutput(outputId = "res3")
    )
  )
)

server <- function(input, output, session) {
  
  res_dat1 <- callModule(
    chooseDataServer, id = "choose1",
    launchOnStart = FALSE
  )
  output$res1 <- renderPrint({
    str(reactiveValuesToList(res_dat1))
  })
  
  res_dat2 <- callModule(
    chooseDataServer, id = "choose2", selectVars = FALSE,
    launchOnStart = FALSE
  )
  output$res2 <- renderPrint({
    str(reactiveValuesToList(res_dat2))
  })
  
  res_dat3 <- callModule(
    chooseDataServer, id = "choose3", data = iris,
    launchOnStart = FALSE
  )
  output$res3 <- renderPrint({
    str(reactiveValuesToList(res_dat3))
  })
  
}

shinyApp(ui, server)


}

}
