% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_merge.R
\name{struct.merge}
\alias{struct.merge}
\title{Merging of structures into a new structure}
\usage{
struct.merge(
  ref.struct,
  add.struct,
  roi.name = NULL,
  roi.sname = NULL,
  roi.idx = NULL,
  suffix = "",
  alias = "",
  description = ""
)
}
\arguments{
\item{ref.struct}{struct class object. All RoI of this structure are kept.}

\item{add.struct}{struct class object. Only the selected RoI are kept for merging.}

\item{roi.name}{Vector of exact names of the RoI in the \code{add.struct} object.
By default \code{roi.name = NULL}. See Details.}

\item{roi.sname}{Vector of names or parts of names of the RoI in the
\code{add.struct} object. By default \code{roi.sname = NULL}. See Details.}

\item{roi.idx}{Vector of indices of the RoI that belong to the \code{add.struct}
object. By default \code{roi.idx = NULL}. See Details.}

\item{suffix}{Character string. \code{'-suffix'} is added to RoI name.}

\item{alias}{Character string, \code{$alias} of the resulted object.}

\item{description}{Character string, describing the the resulted object.}
}
\value{
Returns a struct class object. See \link[espadon]{espadon.class} for
class definitions.
}
\description{
The \code{struct.merge} function merges two structures
into a new one. It is useful for comparing contours, for example.
}
\details{
If \code{roi.name}, \code{roi.sname}, and \code{roi.idx} are all
\code{NULL}, then all RoI of add.struct are selected.
}
\note{
Beware that, when merging structures, some RoI may have same name or
\code{roi.info$roi.pseudo}. In this case \code{struct.merge} prints a warning
message. Consider changing \code{suffix} to avoid the ambiguity.
}
\examples{
# loading of toy-patient objects (decrease dxyz and increase beam.nb for 
# better result)
step <- 5
patient <- toy.load.patient (modality = c("rtdose"),
                             dxyz = rep (step, 3), beam.nb = 3)
D <- patient$rtdose[[1]]  

# isodose 50\% Dmax Gy and 90\% Dmax
bin50 <- bin.from.vol (D, min = 0.5 * D$max.pixel)
bin90 <- bin.from.vol (D, min = 0.9 * D$max.pixel)
S.isodose50 <- struct.from.bin (bin50, roi.name = "50pc" , 
                                roi.color = "#00FFFF") 
S.isodose90 <- struct.from.bin (bin90, roi.name = "90pc" , 
                                roi.color = "#FFFF00")
S <- struct.merge (S.isodose50, S.isodose90, alias = "isodose",
                   description = paste ("isodose of", D$object.alias)) 
# Dmax location :
z.dmax <- get.xyz.from.index(which (D$vol3D.data == D$max.pixel), D)[1,3]                 
display.plane(top = D, struct = S, view.coord = z.dmax, legend.shift = -50)                               
}
\seealso{
\link[espadon]{struct.from.bin}.
}
