% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_subtraction.R
\name{bin.subtraction}
\alias{bin.subtraction}
\title{Subtraction of two binaries}
\usage{
bin.subtraction(vol1, vol2, alias = "", description = NULL)
}
\arguments{
\item{vol1, vol2}{"volume" class objects of "binary" modality.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol1$object.alias, "-", vol2$object.alias)}.}
}
\value{
Returns a "volume" class object of "binary" modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{vol1} and \code{vol2}, in which \code{vol2} is subtracted from \code{vol1}.
}
\description{
The \code{bin.subtraction} function creates a "volume" class
object of "binary" modality, representing the subtraction of two binary objects.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("mr", "rtstruct"), roi.name = "", 
                             dxyz = rep (step, 3))
MR <- patient$mr[[1]]
S <- patient$rtstruct[[1]]

z.ptv <- S$roi.info$Gz[S$roi.info$roi.pseudo == "ptv"]

# binaries
bin.patient <- bin.from.roi (MR, struct = S, roi.name = "patient",
                           alias = "patient", T.MAT = patient$T.MAT)
bin.ptv <- bin.from.roi (MR, struct = S, roi.name = "ptv",
                           alias = "ptv", T.MAT = patient$T.MAT)

#' calculation of the 'patient - ptv' binary
bin <- bin.subtraction (bin.patient, bin.ptv, alias = "patient - ptv")
display.plane (MR, top = bin, view.coord = z.ptv, 
               display.ref = S$ref.pseudo, T.MAT = patient$T.MAT,
               interpolate = FALSE)
}
