% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_rotate.R
\name{signal_rotate}
\alias{signal_rotate}
\title{Rotate signal vectors using a 3-D rotation matrix.}
\usage{
signal_rotate(data, angle)
}
\arguments{
\item{data}{\code{List}, \code{data frame} or \code{matrix}, seismic
componenents to be processed. If \code{data} is a matrix, the components 
must be organised as rows. Also, \code{data} can be a list of 
\code{eseis} objects. If a matrix, this matrix must contain either two 
columns (x- and y-component) or three columns (x-, y-, and z-component), 
in exactly that order of the components.}

\item{angle}{\code{Numeric} value, rotation angle in degrees.}
}
\value{
\code{Numeric} matrix, the 3-dimensional rotation matrix.
}
\description{
The function rotates the horizontal components of the input data according 
to the specified angle.
}
\examples{

## create synthetic data set
data <- rbind(x = sin(seq(0, pi, length.out = 10)),
y = sin(seq(0, pi, length.out = 10)),
z = rep(0, 10))

## rotate the data set
x_rot <- signal_rotate(data = data, 
                       angle = 15)
                      
## plot the rotated data set 
plot(x_rot[1,], col = 1, ylim = c(-2, 2))
points(x_rot[2,], col = 2)
points(x_rot[3,], col = 3)

}
\author{
Michael Dietze
}
\keyword{eseis}
