% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest_functions.R
\name{esr_backtest}
\alias{esr_backtest}
\title{Expected Shortfall Regression Backtest}
\usage{
esr_backtest(
  r,
  q,
  e,
  alpha,
  version,
  B = 0,
  cov_config = list(sparsity = "nid", sigma_est = "scl_sp", misspec = TRUE)
)
}
\arguments{
\item{r}{A vector of returns.}

\item{q}{A vector of Value-at-Risk forecasts.}

\item{e}{A vector of Expected Shortfall forecasts.}

\item{alpha}{Scalar probability level in (0, 1).}

\item{version}{Version of the backtest to be used}

\item{B}{Number of bootstrap samples. Set to 0 to disable bootstrapping.}

\item{cov_config}{a list with three components: sparsity, sigma_est, and misspec, see \link[esreg]{vcovA}}
}
\value{
Returns a list with the following components:
\itemize{
\item pvalue_two_sided_asymptotic
\item pvalue_one_sided_asymptotic (for version 3)
\item pvalue_two_sided_bootstrap
\item pvalue_one_sided_bootstrap (for version 3)
}
}
\description{
This function implements multiple expected shortfall regression (esreg)
based backtests.
Using the \code{version} argument, the following backtests are available:
\enumerate{
\item ("Strict ESR") Regresses the returns on the expected shortfall forecasts
and tests the ES coefficients for (0, 1).
\item ("Auxiliary ESR") Regresses the returns on the quantile and the expected shortfall forecasts
and tests the ES coefficients for (0, 1).
\item ("Strict Intercept") Tests whether the expected shortfall of the forecast error r - e is zero.
}
}
\examples{
data(risk_forecasts)
r <- risk_forecasts$r
q <- risk_forecasts$q
e <- risk_forecasts$e
esr_backtest(r = r, q = q, e = e, alpha = 0.025, version = 1)
}
\references{


\href{https://doi.org/10.1093/jjfinec/nbaa013}{Bayer & Dimitriadis (2020)}
}
