% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Filter.R
\name{erp.filter}
\alias{erp.filter}
\title{Filter ERP data using a Butterworth filter from the "signal" package}
\usage{
erp.filter(data, freq, ftype = "low", order = 4)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{freq}{A value between 0 and 1 specifying the cutoff frequency (the erp.easy
adapted function supports digital filters only, where 1 is the Nyquist
frequency). For example, for a sampling rate of 1000 Hz, a cutoff value
of 12 Hz would be designated as 0.012 (12 / 1000).  A cutoff value of 8
Hz would be 0.008 (8 / 1000).}

\item{ftype}{The type of filter to be used: values include: high-pass
("high"), low-pass ("low"), stop-band ("stop"), and pass-band ("pass").
The default is set to "low."}

\item{order}{The complexity, or "order" of the Butterworth filter.  The default
   value is a 4th order filter (24 dB/octave).}
}
\value{
A data frame identical to the original data frame, but with filtered amplitudes.
}
\description{
\code{erp.filter} Using the "signal" package, erp.easy data frames can be
   filtered with a variety of Butterworth filters.
}
\details{
See \href{https://cran.r-project.org/package=signal}{signal}
   package reference manual for detailed instructions for using the \code{butter}
   function.
}
\examples{
# Low pass filter ERP data (sampled at 250 Hz) with a cutoff frequency of 8 Hz
filtered <- erp.filter(ERPdata, freq = 0.032, ftype = "low", order = 4)
grandaverage(filtered, "V78", window = c(1000, 1500))
}
\author{
Travis Moore
}

