% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.simulate.R
\name{control.simulate.ergm}
\alias{control.simulate.ergm}
\alias{control.simulate.formula.ergm}
\alias{control.simulate}
\alias{control.simulate.formula}
\title{Auxiliary for Controlling ERGM Simulation}
\usage{
control.simulate.formula.ergm(
  MCMC.burnin = MCMC.interval * 16,
  MCMC.interval = 1024,
  MCMC.prop = trim_env(~sparse),
  MCMC.prop.weights = "default",
  MCMC.prop.args = list(),
  MCMC.batch = NULL,
  MCMC.effectiveSize = NULL,
  MCMC.effectiveSize.damp = 10,
  MCMC.effectiveSize.maxruns = 1000,
  MCMC.effectiveSize.burnin.pval = 0.2,
  MCMC.effectiveSize.burnin.min = 0.05,
  MCMC.effectiveSize.burnin.max = 0.5,
  MCMC.effectiveSize.burnin.nmin = 16,
  MCMC.effectiveSize.burnin.nmax = 128,
  MCMC.effectiveSize.burnin.PC = FALSE,
  MCMC.effectiveSize.burnin.scl = 1024,
  MCMC.effectiveSize.order.max = NULL,
  MCMC.maxedges = Inf,
  MCMC.packagenames = c(),
  MCMC.runtime.traceplot = FALSE,
  network.output = "network",
  term.options = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)

control.simulate(
  MCMC.burnin = MCMC.interval * 16,
  MCMC.interval = 1024,
  MCMC.prop = trim_env(~sparse),
  MCMC.prop.weights = "default",
  MCMC.prop.args = list(),
  MCMC.batch = NULL,
  MCMC.effectiveSize = NULL,
  MCMC.effectiveSize.damp = 10,
  MCMC.effectiveSize.maxruns = 1000,
  MCMC.effectiveSize.burnin.pval = 0.2,
  MCMC.effectiveSize.burnin.min = 0.05,
  MCMC.effectiveSize.burnin.max = 0.5,
  MCMC.effectiveSize.burnin.nmin = 16,
  MCMC.effectiveSize.burnin.nmax = 128,
  MCMC.effectiveSize.burnin.PC = FALSE,
  MCMC.effectiveSize.burnin.scl = 1024,
  MCMC.effectiveSize.order.max = NULL,
  MCMC.maxedges = Inf,
  MCMC.packagenames = c(),
  MCMC.runtime.traceplot = FALSE,
  network.output = "network",
  term.options = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)

control.simulate.formula(
  MCMC.burnin = MCMC.interval * 16,
  MCMC.interval = 1024,
  MCMC.prop = trim_env(~sparse),
  MCMC.prop.weights = "default",
  MCMC.prop.args = list(),
  MCMC.batch = NULL,
  MCMC.effectiveSize = NULL,
  MCMC.effectiveSize.damp = 10,
  MCMC.effectiveSize.maxruns = 1000,
  MCMC.effectiveSize.burnin.pval = 0.2,
  MCMC.effectiveSize.burnin.min = 0.05,
  MCMC.effectiveSize.burnin.max = 0.5,
  MCMC.effectiveSize.burnin.nmin = 16,
  MCMC.effectiveSize.burnin.nmax = 128,
  MCMC.effectiveSize.burnin.PC = FALSE,
  MCMC.effectiveSize.burnin.scl = 1024,
  MCMC.effectiveSize.order.max = NULL,
  MCMC.maxedges = Inf,
  MCMC.packagenames = c(),
  MCMC.runtime.traceplot = FALSE,
  network.output = "network",
  term.options = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)

control.simulate.ergm(
  MCMC.burnin = NULL,
  MCMC.interval = NULL,
  MCMC.scale = 1,
  MCMC.prop = NULL,
  MCMC.prop.weights = NULL,
  MCMC.prop.args = NULL,
  MCMC.batch = NULL,
  MCMC.effectiveSize = NULL,
  MCMC.effectiveSize.damp = 10,
  MCMC.effectiveSize.maxruns = 1000,
  MCMC.effectiveSize.burnin.pval = 0.2,
  MCMC.effectiveSize.burnin.min = 0.05,
  MCMC.effectiveSize.burnin.max = 0.5,
  MCMC.effectiveSize.burnin.nmin = 16,
  MCMC.effectiveSize.burnin.nmax = 128,
  MCMC.effectiveSize.burnin.PC = FALSE,
  MCMC.effectiveSize.burnin.scl = 1024,
  MCMC.effectiveSize.order.max = NULL,
  MCMC.maxedges = Inf,
  MCMC.packagenames = NULL,
  MCMC.runtime.traceplot = FALSE,
  network.output = "network",
  term.options = NULL,
  parallel = 0,
  parallel.type = NULL,
  parallel.version.check = TRUE,
  parallel.inherit.MT = FALSE,
  ...
)
}
\arguments{
\item{MCMC.burnin}{Number of proposals before any MCMC sampling is done. It
typically is set to a fairly large number.}

\item{MCMC.interval}{Number of proposals between sampled statistics.}

\item{MCMC.prop}{Specifies the proposal (directly) and/or
a series of "hints" about the structure of the model being
sampled. The specification is in the form of a one-sided formula
with hints separated by \code{+} operations. If the LHS exists and is
a string, the proposal to be used is selected directly.

A common and default "hint" is \code{~sparse}, indicating
that the network is sparse and that the sample should put roughly
equal weight on selecting a dyad with or without a tie as a
candidate for toggling.}

\item{MCMC.prop.weights}{Specifies the proposal
distribution used in the MCMC Metropolis-Hastings algorithm.  Possible
choices depending on selected \code{reference} and \code{constraints}
arguments of the \code{\link[=ergm]{ergm()}} function, but often include \code{"TNT"}
and \code{"random"}, and the \code{"default"} is to use the one with the
highest priority available.}

\item{MCMC.prop.args}{An alternative, direct way of
specifying additional arguments to proposal.}

\item{MCMC.batch}{if not 0 or \code{NULL}, sample about this many
networks per call to the lower-level code; this can be useful if
\verb{output=} is a function, where it can be used to limit the number
of networks held in memory at any given time.}

\item{MCMC.effectiveSize, MCMC.effectiveSize.damp, MCMC.effectiveSize.maxruns, MCMC.effectiveSize.burnin.pval, MCMC.effectiveSize.burnin.min, MCMC.effectiveSize.burnin.max, MCMC.effectiveSize.burnin.nmin, MCMC.effectiveSize.burnin.nmax, MCMC.effectiveSize.burnin.PC, MCMC.effectiveSize.burnin.scl, MCMC.effectiveSize.order.max}{Set \code{MCMC.effectiveSize} to a non-NULL value to adaptively
determine the burn-in and the MCMC length needed to get the
specified effective size; 50 is a reasonable value. In the
adaptive MCMC mode, MCMC is run forward repeatedly
(\code{MCMC.samplesize*MCMC.interval} steps, up to
\code{MCMC.effectiveSize.maxruns} times) until the target effective
sample size is reached or exceeded.

After each run, the returned statistics are mapped to the
estimating function scale, then an exponential decay model is fit
to the scaled statistics to find that burn-in which would reduce
the difference between the initial values of statistics and their
equilibrium values by a factor of \code{MCMC.effectiveSize.burnin.scl}
of what it initially was, bounded by \code{MCMC.effectiveSize.min} and
\code{MCMC.effectiveSize.max} as proportions of sample size. If the
best-fitting decay exceeds \code{MCMC.effectiveSize.max}, the
exponential model is considered to be unsuitable and
\code{MCMC.effectiveSize.min} is used.

A Geweke diagnostic is then run, after thinning the sample to
\code{MCMC.effectiveSize.burnin.nmax}. If this Geweke diagnostic
produces a \eqn{p}-value higher than
\code{MCMC.effectiveSize.burnin.pval}, it is accepted.

If \code{MCMC.effectiveSize.burnin.PC>0}, instead of using the full
sample for burn-in estimation, at most this many principal
components are used instead.

The effective
size of the post-burn-in sample is computed via Vats, Flegal, and
Jones (2015), and compared to the target effective size. If it is
not matched, the MCMC run is resumed, with the additional draws
needed linearly extrapolated but weighted in favor of the
baseline \code{MCMC.samplesize} by the weighting factor
\code{MCMC.effectiveSize.damp} (higher = less damping). Lastly, if
after an MCMC run, the number of samples equals or exceeds
\code{2*MCMC.samplesize}, the chain will be thinned by 2 until it
falls below that, while doubling
\code{MCMC.interval}. \code{MCMC.effectiveSize.order.max} can be used to
set the order of the AR model used to estimate the effective
sample size and the variance for the Geweke diagnostic.}

\item{MCMC.maxedges}{The maximum number of edges that may occur during the MCMC sampling. If this number is exceeded at any time, sampling is stopped immediately.}

\item{MCMC.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{MCMC.runtime.traceplot}{Logical: If \code{TRUE}, plot traceplots of the MCMC
sample.}

\item{network.output}{R class with which to output networks. The options are
"network" (default) and "edgelist.compressed" (which saves space but only
supports networks without vertex attributes)}

\item{term.options}{A list of additional arguments to be passed to term initializers. See \code{\link[=term.options]{? term.options}}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See the entry on \link[=ergm-parallel]{parallel processing}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported values
are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the \code{parallel}
package with PSOCK clusters. See \code{\link{ergm-parallel}}}

\item{parallel.version.check}{Logical: If TRUE, check that the version of
\code{\link[=ergm-package]{ergm}} running on the slave nodes is the same as
that running on the master node.}

\item{parallel.inherit.MT}{Logical: If TRUE, slave nodes and
processes inherit the \code{\link[=set.MT_terms]{set.MT_terms()}} setting.}

\item{\dots}{A dummy argument to catch deprecated or mistyped control parameters.}

\item{MCMC.scale}{For \code{control.simulate.ergm()} inheriting
\code{MCMC.burnin} and \code{MCMC.interval} from the \code{\link{ergm}} fit, the
multiplier for the inherited values. This can be useful because
MCMC parameters used in the fit are tuned to generate a specific
effective sample size for the sufficient statistic in a large
MCMC sample, so the inherited values might not generate
independent realisations.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning ERGM
simulation. \code{control.simulate}, \code{control.simulate.formula}, and
\code{control.simulate.formula.ergm} are all aliases for the same
function.

While the others supply a full set of simulation
settings, \code{control.simulate.ergm} when passed as a control
parameter to \code{\link[=simulate.ergm]{simulate.ergm()}} allows some settings to be
inherited from the ERGM stimation while overriding others.
}
\details{
This function is only used within a call to the \code{\link{simulate}}
function.  See the \code{usage} section in \code{\link{simulate.ergm}} for
details.
}
\seealso{
\code{\link{simulate.ergm}}, \code{\link{simulate.formula}}.
\code{\link{control.ergm}} performs a similar function for
\code{\link{ergm}}; \code{\link{control.gof}} performs a similar function
for \code{\link{gof}}.
}
\keyword{models}
