% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{ttriple-ergmTerm}
\alias{ttriple-ergmTerm}
\alias{InitErgmTerm.ttriple}
\alias{InitErgmTerm.ttriad}
\alias{ttriad-ergmTerm}
\title{Transitive triples}
\usage{
# binary: ttriple(attr=NULL, diff=FALSE, levels=NULL)

# binary: ttriad
}
\arguments{
\item{attr, diff}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.) If \code{attr} is specified and \code{diff} is \code{FALSE} ,
then the count is over the number of transitive triples where all three nodes have the same value of
the attribute. If \code{attr} is specified and \code{diff} is \code{TRUE} ,
then one statistic is added for each value of \code{attr} ,
equal to the number of triangles where all three nodes have that value of the attribute.}

\item{levels}{add one statistic for each value specified if \code{diff} is \code{TRUE}. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{attr}{quantitative attribute (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}
}
\description{
By default, this term adds one statistic to the model, equal to the number of transitive
triples in the network, defined as a set of edges \eqn{\{(i{\rightarrow}j),
  j{\rightarrow}k), (i{\rightarrow}k)\}}{\{(i,j), (j,k), (i,k)\}} . Note that
\code{triangle} equals \code{ttriple+ctriple} for a directed network, so at
most two of the three terms can be in a model.
}
\note{
This term can only be used with directed networks.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{triad-related}
