% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm-terms-index.R
\name{search.ergmConstraints}
\alias{search.ergmConstraints}
\title{Search the ERGM Constraint}
\usage{
search.ergmConstraints(search, keywords, name, packages)
}
\arguments{
\item{search}{optional character search term to search for in the text of the
constraint descriptions. Only matching constraints will be returned. Matching is case
insensitive.}

\item{keywords}{optional character vector of keyword tags to use to
restrict the results (i.e. 'curved', 'triad-related')}

\item{name}{optional character name of a specific constraint to return}

\item{packages}{optional character vector indicating the subset of packages in which to search}
}
\value{
prints out the name and short description of matching constraints, and
invisibly returns them as a list.  If \code{name} is specified, prints out
the full definition for the named constraint.
}
\description{
Searches through the \code{\link{ergm.constraints}} help page and prints out a
list of constraints appropriate for the specified network's structural
constraints, optionally restricting by additional keywords and search term
matches.
}
\details{
Uses \code{\link{grep}} internally to match the search terms against the constraint
description, so \code{search} is currently matched as a single phrase.
Keyword tags will only return a match if all of the specified tags are
included in the constraint
}
\examples{
\donttest{
# find all of the constraint that mention degrees
search.ergmConstraints('degree')

# search on multiple keywords
search.ergmConstraints(keywords=c('directed','dyad-independent'))

# print out the content for a specific constraint
search.ergmConstraints(name='b1degrees')

# request the bipartite keyword in the ergm package
search.ergmConstraints(keywords='directed', packages='ergm')
}
}
\seealso{
See also \code{\link{ergm.constraints}} for the complete documentation
}
\author{
skyebend@uw.edu
}
