% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.node.attr.R
\name{get.node.attr}
\alias{get.node.attr}
\title{Retrieve and check assumptions about vertex attributes (nodal covariates) in
a network}
\usage{
get.node.attr(nw, attrname, functionname = NULL, numeric = FALSE)
}
\arguments{
\item{nw}{a \code{\link{network}} object}

\item{attrname}{the name of a nodal attribute, as a character string}

\item{functionname}{the name of the calling function a character string;
this is only used for the warning messages that accompany a halt}

\item{numeric}{logical, whether to halt execution if the return vector is
not numeric; default=FALSE}
}
\value{
returns the vector of 'attrname' covariates for the vertices in the
network
}
\description{
The \code{get.node.attr} function returns the vector of nodal covariates for
the given network and specified attribute if the attribute exists -
execution will halt if the attribute is not correctly given as a single
string or is not found in the vertex attribute list; optionally
\code{get.node.attr} will also check that return vector is numeric, halting
execution if not. The purpose is to validate assumptions before passing
attribute data into an ergm term.
}
\examples{

data(faux.mesa.high)
get.node.attr(faux.mesa.high,'Grade')
}
\seealso{
\code{\link[network]{get.vertex.attribute}} for a version without
the checking functionality
}
\keyword{internal}
