% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.getMCMCsample.R
\name{ergm_MCMC_sample}
\alias{ergm_MCMC_sample}
\alias{ergm_MCMC_slave}
\title{Internal Function to Sample Networks and Network Statistics}
\usage{
ergm_MCMC_sample(nw, model, proposal, control, theta = NULL,
  response = NULL, update.nws = TRUE, verbose = FALSE, ...,
  eta = ergm.eta(theta, model$etamap))

ergm_MCMC_slave(Clist, proposal, eta, control, verbose, ...,
  prev.run = NULL, burnin = NULL, samplesize = NULL,
  interval = NULL, maxedges = NULL)
}
\arguments{
\item{nw}{a \code{\link{network}} object representing the sampler state.}

\item{model}{an \code{\link{ergm_model}} to be sampled from, as returned by
\code{\link[=ergm_model]{ergm_model()}}.}

\item{proposal}{a list of the parameters needed for
Metropolis-Hastings proposals and the result of calling
\code{\link[=ergm_proposal]{ergm_proposal()}}.}

\item{control}{list of MCMC tuning parameters; see
\code{\link[=control.ergm]{control.ergm()}}.}

\item{theta}{the (possibly curved) parameters of the model.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{update.nws}{whether to actually update the network state or
to return an object "promising" to update the network.}

\item{verbose}{verbosity level.}

\item{...}{additional arugments.}

\item{eta}{the natural parameters of the model; by default constructed from \code{theta}.}

\item{Clist}{the list of parameters returned by
\code{\link{ergm.Cprepare}}}

\item{prev.run}{a summary of the state of the sampler allowing a
run to be resumed quickly by \code{ergm_MCMC_slave}.}

\item{burnin, samplesize, interval, maxedges}{MCMC paramters that can
be used to temporarily override those in the \code{control} list.}
}
\value{
\code{ergm_MCMC_sample} returns a list
containing:
\item{stats}{an \code{\link{mcmc.list}} with sampled statistics.}
\item{networks}{a list of final sampled networks, one for each thread.}
\item{status}{status code, propagated from \code{ergm.mcmcslave}.}
\item{final.interval}{adaptively determined MCMC interval.}

If \code{update.nws==FALSE}, rather than returning the updated networks,
the function will remove all edges from the input networks, attach
a network attribute \code{.update} with the new edge information, and
change class name to prevent the resulting object from being
accessed or modified by functions that do not understand it.

\code{ergm_MCMC_slave} returns the MCMC sample as a list of
the following: \item{s}{the matrix of statistics.}
\item{newnwtails}{the vector of tails for the new network.}
\item{newnwheads}{the vector of heads for the new network.}
\item{newnwweights}{the vector of weights for the new network (if
applicable)} \item{status}{success or failure code: \code{0} is
success, \code{1} for too many edges, and \code{2} for a
Metropolis-Hastings proposal failing.}  \item{maxedges}{maximum
allowed edges at the time of return.}
}
\description{
This is an internal function, not normally called directly by the
user. The \code{ergm_MCMC_sample} function samples networks and
network statistics using an MCMC algorithm via \code{MCMC_wrapper}
and is caple of running in multiple threads using
\code{ergm_MCMC_slave}.

The \code{ergm_MCMC_slave} function calls the actual C
routine and does minimal preprocessing.
}
\details{
Note that the returned stats will be relative to the original network, i.e.,
the calling function must shift the statistics if required. The calling
function must also attach column names to the statistics matrix if required.
}
\note{
Unlike its predecessor \code{ergm.getMCMCsample},
\code{ergm_MCMC_sample} does not return \code{statsmatrix} or \code{newnetwork}
elements. Rather, if parallel processing is not in effect,
\code{stats} is an \code{\link{mcmc.list}} with one chain and
\code{networks} is a list with one element.
}
