% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.ergm.R, R/summary.ergm.R
\name{print.summary.ergm}
\alias{print.summary.ergm}
\alias{summary.ergm}
\title{Summarizing ERGM Model Fits}
\usage{
\method{print}{summary.ergm}(x, digits = max(3, getOption("digits") - 3),
  correlation = FALSE, covariance = FALSE,
  signif.stars = getOption("show.signif.stars"), eps.Pvalue = 1e-04,
  print.header = TRUE, print.formula = TRUE, print.fitinfo = TRUE,
  print.coefmat = TRUE, print.message = TRUE, print.deviances = TRUE,
  print.drop = TRUE, print.offset = TRUE, print.degeneracy = TRUE,
  ...)

\method{summary}{ergm}(object, ..., correlation = FALSE,
  covariance = FALSE, total.variation = TRUE)
}
\arguments{
\item{x}{object of class \code{summary.ergm} returned by
\code{\link[=summary.ergm]{summary.ergm()}}.}

\item{digits}{Significant digits for coefficients}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix
of the estimated parameters is returned and printed.}

\item{covariance}{logical; if \code{TRUE}, the covariance matrix of
the estimated parameters is returned and printed.}

\item{signif.stars}{whether to print dots and stars to signify
statistical significance. See \code{\link[=print.summary.lm]{print.summary.lm()}}.}

\item{eps.Pvalue}{\eqn{p}-values below this level will be printed
as "<\code{eps.Pvalue}".}

\item{print.header, print.formula, print.fitinfo, print.coefmat, print.message, print.deviances, print.drop, print.offset, print.degeneracy}{which components of the fit summary to print.}

\item{\dots}{Arguments to \code{\link{logLik.ergm}}}

\item{object}{an object of class \code{"ergm"}, usually, a result
of a call to \code{\link{ergm}}.}

\item{total.variation}{logical; if \code{TRUE}, the standard errors
reported in the \code{Std. Error} column are based on the sum of
the likelihood variation and the MCMC variation. If \code{FALSE}
only the likelihood varuation is used. The \eqn{p}-values are
based on this source of variation.}
}
\value{
The function \code{\link{summary.ergm}} computes and
returns a list of summary statistics of the fitted
\code{\link{ergm}} model given in \code{object}. Note that for
backwards compatibility, it returns two coefficient tables:
\code{$coefs} which does not contain the z-statistics and
\code{$coefficeints} which does (and is therefore more similar to
those returned by \code{\link[=summary.lm]{summary.lm()}}).
}
\description{
\code{\link[base]{summary}} method for \code{\link{ergm}} fits.
}
\details{
\code{\link{summary.ergm}} tries to be smart about formatting the
coefficients, standard errors, etc.
}
\examples{

 data(florentine)

 x <- ergm(flomarriage ~ density)
 summary(x)

}
\seealso{
network, ergm, print.ergm.  The model fitting function
\code{\link{ergm}}, \code{\link{summary}}.

Function \code{\link{coef}} will extract the matrix of coefficients with
standard errors, t-statistics and p-values.
}
\keyword{models}
\keyword{regression}
