% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.san.R
\name{control.san}
\alias{control.san}
\title{Auxiliary for Controlling SAN}
\usage{
control.san(SAN.maxit = 4, SAN.tau = 1, SAN.invcov = NULL,
  SAN.invcov.diag = FALSE, SAN.nsteps.alloc = function(nsim)
  2^seq_len(nsim), SAN.nsteps = 2^19, SAN.samplesize = 2^12,
  SAN.init.maxedges = 20000, SAN.max.maxedges = 2^26,
  SAN.prop.weights = "default", SAN.prop.args = list(),
  SAN.packagenames = c(), term.options = list(), seed = NULL,
  parallel = 0, parallel.type = NULL, parallel.version.check = TRUE)
}
\arguments{
\item{SAN.maxit}{Number of temperature levels to use.}

\item{SAN.tau}{Tuning parameter, specifying the temperature of the
process during the \emph{penultimate} iteration. (During the last
iteration, the temperature is set to 0, resulting in a greedy
search, and during the previous iterations, the temperature is
set to \code{SAN.tau*(iterations left after this one)}.}

\item{SAN.invcov}{Initial inverse covariance matrix used to
calculate Mahalanobis distance in determining how far a proposed
MCMC move is from the \code{target.stats} vector.  If \code{NULL},
initially set to the identity matrix, then during subsequent runs
estimated empirically.}

\item{SAN.invcov.diag}{Whether to only use the diagonal of the
covariance matrix. It seems to work better in practice.}

\item{SAN.nsteps.alloc}{Either a numeric vector or a function of
the number of runs giving a sequence of relative lengths of
simulated annealing runs.}

\item{SAN.nsteps}{Number of MCMC proposals for all the annealing runs combined.}

\item{SAN.samplesize}{Number of realisations' statistics to obtain for tuning purposes.}

\item{SAN.init.maxedges}{Maximum number of edges expected in network.}

\item{SAN.max.maxedges}{Hard upper bound on the number of edges in the network.}

\item{SAN.prop.weights}{Specifies the method to allocate probabilities of
being proposed to dyads. Defaults to \code{"default"}, which picks a
reasonable default for the specified constraint.  Other possible values are
\code{"TNT"}, \code{"random"}, and \code{"nonobserved"}, though not all
values may be used with all possible constraints.}

\item{SAN.prop.args}{An alternative, direct way of specifying additional
arguments to proposal.}

\item{SAN.packagenames}{Names of packages in which to look for change
statistic functions in addition to those autodetected. This argument should
not be needed outside of very strange setups.}

\item{term.options}{A list of additional arguments to be passed to term initializers. It can also be set globally via \code{option(ergm.term=list(...))}.}

\item{seed}{Seed value (integer) for the random number generator.  See
\code{\link[base]{set.seed}}.}

\item{parallel}{Number of threads in which to run the sampling. Defaults to
0 (no parallelism). See the entry on \link[=ergm-parallel]{parallel processing}
for details and troubleshooting.}

\item{parallel.type}{API to use for parallel processing. Supported values
are \code{"MPI"} and \code{"PSOCK"}. Defaults to using the \code{parallel}
package with PSOCK clusters. See \code{\link{ergm-parallel}}}

\item{parallel.version.check}{Logical: If TRUE, check that the version of
\code{\link[=ergm-package]{ergm}} running on the slave nodes is the same as
that running on the master node.}
}
\value{
A list with arguments as components.
}
\description{
Auxiliary function as user interface for fine-tuning simulated annealing
algorithm.
}
\details{
This function is only used within a call to the \code{\link{san}} function.
See the \code{usage} section in \code{\link{san}} for details.
}
\seealso{
\code{\link{san}}
}
\keyword{models}
