% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmReference.R
\name{Poisson-ergmReference}
\alias{Poisson-ergmReference}
\alias{InitErgmReference.Poisson}
\title{Poisson-reference ERGM}
\usage{
# Poisson
}
\description{
Specifies each
dyad's baseline distribution to be Poisson with mean 1:
\eqn{h(y)=\prod_{i,j} 1/y_{i,j}!} , with the support of
\eqn{y_{i,j}} being natural numbers (and \eqn{0} ). Using
\link[=ergmTerm]{valued ERGM terms} that are
"generalized" from their binary counterparts, with form
\code{"sum"} (see previous link for the list) produces Poisson
regression. Using \code{\link[=CMP-ergmTerm]{CMP}} induces a
Conway-Maxwell-Poisson distribution that is Poisson when its
coefficient is \eqn{0} and geometric when its coefficient is
\eqn{1} .

@details Three proposal functions are currently implemented, two of them
designed to improve mixing for sparse networks. They can can be
selected via the \verb{MCMC.prop.weights=} control parameter. The
sparse proposals work by proposing a jump to 0. Both of them take
an optional proposal argument \code{p0} (i.e.,
\code{MCMC.prop.args=list(p0=...)} ) specifying the probability of
such a jump. However, the way in which they implement it are
different:
\itemize{
\item \code{"random"}: Select a dyad (i,j) at random, and draw the
proposal \eqn{y_{i,j}^\star \sim \mathrm{Poisson}_{\ne
  y_{i,j}}(y_{i,j}+0.5)} (a Poisson distribution with mean
slightly higher than the current value and conditional on not
proposing the current value).
\item \code{"0inflated"}: As \code{"random"} but, with
probability \code{p0} , propose a jump to 0 instead of a
Poisson jump (if not already at 0). If \code{p0} is not given,
defaults to the "surplus" of 0s in the observed network,
relative to Poisson.
\item \code{"TNT"}: (the default) As \code{"0inflated"} but
instead of selecting a dyad at random, select a tie with
probability \code{p0} , and a random dyad otherwise, as with
the binary TNT. Currently, \code{p0} defaults to 0.2.
}
}
\seealso{
\code{\link{ergmReference}} for index of reference distributions currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmReference", "Poisson", "subsection")}
}
\concept{bipartite}
\concept{directed}
\concept{discrete}
\concept{nonnegative}
\concept{undirected}
\concept{valued}
