% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{epoxy_transform_one_shot}
\alias{epoxy_transform_one_shot}
\alias{epoxy_transform_wrap}
\alias{epoxy_transform_bold}
\alias{epoxy_transform_italic}
\alias{epoxy_transform_apply}
\alias{epoxy_transform_code}
\alias{epoxy_transform_collapse}
\title{One-shot epoxy transformers}
\usage{
epoxy_transform_wrap(
  before = "**",
  after = before,
  engine = NULL,
  transformer = glue::identity_transformer,
  syntax = lifecycle::deprecated()
)

epoxy_transform_bold(engine = NULL, transformer = glue::identity_transformer)

epoxy_transform_italic(engine = NULL, transformer = glue::identity_transformer)

epoxy_transform_apply(
  .f = identity,
  ...,
  transformer = glue::identity_transformer
)

epoxy_transform_code(engine = NULL, transformer = glue::identity_transformer)

epoxy_transform_collapse(
  sep = ", ",
  last = sep,
  language = NULL,
  ...,
  transformer = glue::identity_transformer
)
}
\arguments{
\item{before, after}{In \code{epoxy_transform_wrap()}, the characters to be added
before and after variables in the template string.}

\item{engine}{One of \code{"markdown"} (or \code{"md"}), \code{"html"}, or \code{"latex"}. The
default is chosen based on the engine of the chunk where the transform
function is called, or according to the option \code{epoxy.engine}. Caution:
invalid options are silently ignored, falling back to \code{"markdown"}.}

\item{transformer}{The transformer to apply to the replacement string. This
argument is used for chaining the transformer functions. By providing a
function to this argument you can apply an additional transformation after
the current transformation. In nearly all cases, you can let
\code{epoxy_transform()} handle this for you. The chain ends when
\code{\link[glue:identity_transformer]{glue::identity_transformer()}} is used as the \code{transformer}.}

\item{syntax}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{engine} instead.}

\item{.f}{A function, function name or \code{\link[purrr:map]{purrr::map()}}-style inline function.}

\item{...}{Transformer functions, e.g.
\link{epoxy_transform_bold} or the name of an \pkg{epoxy}
transform function, e.g. \code{"bold"}, or a call to a transform function, e.g.
\code{\link[=epoxy_transform_bold]{epoxy_transform_bold()}}. \code{epoxy_transform()} chains the transformer
functions together, applying the transformers in order from first to last.

For example, \code{epoxy_transform("bold", "collapse")} results in replaced
strings that are emboldened \emph{and then} collapsed, e.g. \verb{**a** and **b**}.
On the other hand, \code{epoxy_transform("collapse", "bold")}  will collapse the
vector \emph{and then} embolden the entire string.

In \code{epoxy_transform_apply()}, the \code{...} are passed to the underlying call
the underlying function call.

In \code{epoxy_transform_collapse()}, the \code{...} are ignored.}

\item{sep, last}{The separator to use when joining the vector elements when
the expression ends with a \code{*}. Elements are separated by \code{sep}, except for
the last two elements, which use \code{last}.}

\item{language}{In \code{epoxy_transform_collapse()}, \code{language} is passed to
\code{\link[and:and]{and::and()}} or \code{\link[and:and]{and::or()}} to choose the correct and/or phrase and spacing
for the \code{language}. By default, will follow the system language. See
\link[and:and_languages]{and::and_languages} for supported languages.}
}
\value{
A function of \code{text} and \code{envir} suitable for the \code{.transformer} argument of
\code{\link[glue:glue]{glue::glue()}}.
}
\description{
These transformers are useful for applying the same transformation to every
replacement in the template.
}
\section{Functions}{
\itemize{
\item \code{epoxy_transform_wrap()}: Wrap variables with text added before or
after the inline expression.

\item \code{epoxy_transform_bold()}: Embolden variables using \verb{**} in
markdown, \verb{<strong>} in HTML, or \verb{\\textbf\{\}} in LaTeX.

\item \code{epoxy_transform_italic()}: Italicize variables using \verb{_} in
markdown, \verb{<em>} in HTML, or \verb{\\emph\{\}} in LaTeX.

\item \code{epoxy_transform_apply()}: Apply a function to all replacement
expressions.

\item \code{epoxy_transform_code()}: Code format variables using \verb{``} in
markdown, \verb{<code>} in HTML, or \verb{\\texttt\{\}} in LaTeX.

\item \code{epoxy_transform_collapse()}: Collapse vector variables with a
succinct syntax (but see \code{\link[=epoxy_transform_inline]{epoxy_transform_inline()}} for a more readable
option).

}}
\examples{
abc <- c("a", "b", "c")

epoxy("{abc}", .transformer = epoxy_transform_wrap("'"))

epoxy("{abc}", .transformer = epoxy_transform_bold())

epoxy("{abc}", .transformer = epoxy_transform_italic())

epoxy("{abc}", .transformer = epoxy_transform_code())

epoxy("{abc}", .transformer = epoxy_transform_apply(toupper))
}
