#' List drug terms with their frequency co-occurring with terms from the EpSO 
#' ontology in publications since 2015 from the BioASQ 2020 corpus.
#'
#' @source The text mining workflows for data generation are described in 
#' Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558>, Mueller, Bernd et al. (2017)
#' <doi:10.1007/978-3-319-58694-6_22>, and Mueller, Bernd and Rebholz-Schuhmann,
#' Dietrich (2020) <doi:10.1007/978-3-030-43887-6_52>. The source data set for 
#' generating the data co-occurrence lists is the BioASQ 2020 corpus filtered 
#' for documents published since the year 2015. The source ontology for the 
#' creation of the dictionary is the Epilepsy and Seizure 
#' Ontology (EpSO) from https://bioportal.bioontology.org/ontologies/EPSO
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugNamesCoOcEpSO, package="epos")
"rawDrugNamesCoOcEpSO"

#' List drug terms with their frequency co-occurring with terms from the ESSO 
#' ontology in publications since 2015 from the BioASQ 2020 corpus.
#'
#' @source The text mining workflows for data generation are described in 
#' Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558>, Mueller, Bernd et al. (2017)
#' <doi:10.1007/978-3-319-58694-6_22>, and Mueller, Bernd and Rebholz-Schuhmann,
#' Dietrich (2020) <doi:10.1007/978-3-030-43887-6_52>. The source data set for 
#' generating the data co-occurrence lists is the BioASQ 2020 corpus filtered 
#' for documents published since the year 2015. The source ontology for the 
#' creation of the dictionary is Epilepsy Syndrome Seizure 
#' Ontology (ESSO) from https://bioportal.bioontology.org/ontologies/ESSO
#' @examples
#' utils::data(rawDrugNamesCoOcESSO, package="epos")
"rawDrugNamesCoOcESSO"

#' List drug terms with their frequency co-occurring with terms from the EPILONT 
#' ontology in publications since 2015 from the BioASQ 2020 corpus.
#'
#' @source The text mining workflows for data generation are described in 
#' Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558>, Mueller, Bernd et al. (2017)
#' <doi:10.1007/978-3-319-58694-6_22>, and Mueller, Bernd and Rebholz-Schuhmann,
#' Dietrich (2020) <doi:10.1007/978-3-030-43887-6_52>. The source data set for 
#' generating the data co-occurrence lists is the BioASQ 2020 corpus filtered 
#' for documents published since the year 2015. The source ontology for the 
#' creation of the dictionary is the Epilepsy Ontology 
#' (EPILONT) from https://bioportal.bioontology.org/ontologies/EPILONT
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugNamesCoOcEPILONT, package="epos")
"rawDrugNamesCoOcEPILONT"

#' List drug terms with their frequency co-occurring with terms from the EPISEM 
#' ontology in publications since 2015 from the BioASQ 2020 corpus.
#'
#' @source The text mining workflows for data generation are described in 
#' Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558>, Mueller, Bernd et al. (2017)
#' <doi:10.1007/978-3-319-58694-6_22>, and Mueller, Bernd and Rebholz-Schuhmann,
#' Dietrich (2020) <doi:10.1007/978-3-030-43887-6_52>. The source data set for 
#' generating the data co-occurrence lists is the BioASQ 2020 corpus filtered 
#' for documents published since the year 2015. The source ontology for the 
#' creation of the dictionary is the Epilepsy Semiology Ontology (EPISEM) from 
#' https://bioportal.bioontology.org/ontologies/EPISEM
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugNamesCoOcEPISEM, package="epos")
"rawDrugNamesCoOcEPISEM"

#' List drug terms with their frequency co-occurring with terms from the FENICS 
#' ontology in publications since 2015 from the BioASQ 2020 corpus.
#'
#' @source The text mining workflows for data generation are described in 
#' Mueller, Bernd and Hagelstein, Alexandra (2016) 
#' <doi:10.4126/FRL01-006408558>, Mueller, Bernd et al. (2017)
#' <doi:10.1007/978-3-319-58694-6_22>, and Mueller, Bernd and Rebholz-Schuhmann,
#' Dietrich (2020) <doi:10.1007/978-3-030-43887-6_52>. The source data set for 
#' generating the data co-occurrence lists is the BioASQ 2020 corpus filtered 
#' for documents published since the year 2015. The source ontology for the 
#' creation  of the dictionary is the Functional Epilepsy Nomenclature for Ion 
#' Channels (FENICS) from https://bioportal.bioontology.org/ontologies/FENICS
#' @format A named list of drug term frequencies
#' @examples
#' utils::data(rawDrugNamesCoOcFENICS, package="epos")
"rawDrugNamesCoOcFENICS"