% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLegend.R
\name{addLegend}
\alias{addLegend}
\title{addLegend}
\usage{
addLegend(
  r,
  params = NULL,
  direction,
  side,
  location = "right",
  nTicks = 3,
  adj = NULL,
  shortFrac = 0.02,
  longFrac = 0.3,
  axisOffset = 0,
  border = TRUE,
  ramp,
  isInteger = "auto",
  ncolors = 64,
  breaks = NULL,
  minmax = NULL,
  locs = NULL,
  cex.axis = 0.8,
  tcl = NA,
  labelDist = 0.7,
  minDigits = 2
)
}
\arguments{
\item{r}{the epmGrid, rasterLayer, SpatRaster or sf object that has been plotted}

\item{params}{If an epmGrid plot was saved to a variable, provide that here.
Contents will override other arguments.}

\item{direction}{direction of color ramp. If omitted, then direction is
automatically inferred, otherwise can be specified as \code{horizontal} or
\code{vertical}.}

\item{side}{side for tick marks, see \code{\link{axis}} documentation.
Automatically inferred if omitted.}

\item{location}{either a location name (see \code{Details}), or coordinates
for the corners of the bar legend \code{c(xmin, xmax, ymin, ymax)}.}

\item{nTicks}{number of tick marks, besides min and max.}

\item{adj}{if location is top, left, bottom or right, use this argument to
adjust the location of the legend, defined in percent of the figure width.
See Details for additional information.}

\item{shortFrac}{Percent of the plot width range that will be used as the
short dimension of the legend. Only applies to preset location options.}

\item{longFrac}{Percent of the plot width range that will be used as the
long dimension of the legend. Only applies to preset location options.}

\item{axisOffset}{distance from color bar for labels, as a percent of the
plot width.}

\item{border}{logical, should the color legend have a black border}

\item{ramp}{either a vector of color names that will be interpolated, or a
color ramp function that takes an integer (see for example
\code{\link{colorRampPalette}}). If omitted, defaults to default epm color
palette.}

\item{isInteger}{If \code{auto}, automatically determines if \code{r} is
made up of integer values, otherwise \code{TRUE} or \code{FALSE}}

\item{ncolors}{grain size of color ramp}

\item{breaks}{If a custom set of color breaks were used in plotting
\code{r}, pass those color breaks here. This overrides the minmax option.}

\item{minmax}{min and max values from which the color ramp will be derived.
If left as \code{NULL}, the min and max of \code{r} will be used.}

\item{locs}{locations of tick marks, if \code{NULL} automatically placed. If
this is supplied as a character vector, then the labels will be plotted
verbatim.}

\item{cex.axis}{size of axis labels}

\item{tcl}{length of tick marks (see help for tcl in ?par)}

\item{labelDist}{distance from axis to axis labels (passed to \code{mgp})}

\item{minDigits}{minimum number of significant digits for labels}
}
\value{
Invisibly returns a list with the following components.
\itemize{
	\item{coords} {2-column matrix of xy coordinates for each color bin in the legend.}
	\item{width} {Coordinates for the short dimension of the legend.}
	\item{pal} {the color ramp}
	\item{tickLocs} {the tick mark locations in plotting units}
}
}
\description{
Adds a legend to an existing plot, with some additional manual
  controls.
}
\details{
A number of predefined locations exist in this function to make it
  easy to add a legend to a plot.

  Preset \code{locations} are: \code{topleft}, \code{topright},
  \code{bottomleft}, \code{bottomright}, \code{left}, \code{right},
  \code{top} and \code{bottom}. \cr If more fine-tuned control is desired,
  then a numeric vector of length 4 can be supplied to \code{location},
  specifying the min x, max x, min y and max y values for the legend.

  Additionally, the \code{adj} argument can be used to more intuitively
  adjust where the legend is placed. \code{adj} is defined as a percentage
  of the figure width or height, left to right, or bottom to top,
  respectively. For example, if the legend is at the bottom, \code{adj =
  0.8} will place the legend 80\% of the distance from the top of the
  figure, horizontally centered.

	  If an epmGrid object was plotted with \code{\link{plot.epmGrid}}, and if
	  \code{use_tmap = FALSE} was specified, and if that plot was assigned to
	  a variable, then you can supply that variable here to the \code{params}
  argument, and a number of options will be automatically handed over to 
  this function.

  See examples.
}
\examples{
\donttest{
# create square-cell epmGrid object
tamiasEPM2 <- createEPMgrid(tamiasPolyList, resolution = 50000,
	cellType = 'square', method = 'centroid')

# need to disable tmap if we want to anything to a plot
plot(tamiasEPM2, use_tmap = FALSE, legend = FALSE)
addLegend(tamiasEPM2, location = 'right')
addLegend(tamiasEPM2, location = 'top')

# fine-tune placement
addLegend(tamiasEPM2, location=c(113281, 1265200, -1500000, -1401898), side = 1)

# Using the params option
xx <- plot(tamiasEPM2, use_tmap = FALSE, legend = FALSE, 
col = viridisLite::magma)
addLegend(tamiasEPM2, params = xx, location = 'top')

# works with hex grids as well
xx <- plot(tamiasEPM, use_tmap = FALSE, legend = FALSE, 
col = viridisLite::magma)
addLegend(tamiasEPM, params = xx, location = 'top')
}
}
\author{
Pascal Title
}
