% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epw.R
\docType{class}
\name{epw}
\alias{epw}
\title{Read, and modify an EnergyPlus Weather File (EPW)}
\description{
Reading an EPW file starts with function \code{\link[=read_epw]{read_epw()}}, which parses an EPW
file and returns an \code{Epw} object. The parsing process is extremely inspired
by \href{https://openstudio-sdk-documentation.s3.amazonaws.com/cpp/OpenStudio-2.5.1-doc/utilities/html/classopenstudio_1_1_epw_file.html}{OpenStudio utilities library}
with some simplifications.
}
\details{
An EPW file can be divided into two parts, headers and weather data.  The
first eight lines of a standard EPW file are normally headers which contains
data of location, design conditions, typical/extreme periods, ground
temperatures, holidays/daylight savings, data periods and other comments. For
now, eplusr only parses headers of location, holidays/daylight savings and
data periods. All other headers will be left as they were when parsing and
saving. For details on the data structure of EPW file, please see "Chapter 2 - Weather Converter Program"
in EnergyPlus "Auxiliary Programs" documentation. An online version can be
found \href{https://bigladdersoftware.com/epx/docs/}{here}.

There are about 35 variables in the core weather data. However, not all of
them are used by EnergyPlus. Actually, despite of date and time columns, only
14 columns are used:
\enumerate{
\item dry bulb temperature
\item dew point temperature
\item relative humidity
\item atmospheric pressure
\item horizontal infrared radiation intensity from sky
\item direct normal radiation
\item diffuse horizontal radiation
\item wind direction
\item wind speed
\item present weather observation
\item present weather codes
\item snow depth
\item liquid precipitation depth
\item liquid precipitation rate
}
}
\section{Usage}{
\preformatted{epw <- read_epw(path)

epw$city
epw$city <- "city"
epw$state_province
epw$state_province <- "state_province"
epw$country
epw$country <- "country"
epw$data_source
epw$data_source <- "data_source"
epw$wmo_number
epw$wmo_number <- "wmo_number"
epw$latitude
epw$latitude <- "latitude"
epw$longitute
epw$longitute <- "longitute"
epw$time_zone
epw$time_zone <- "time_zone"
epw$elevation
epw$elevation <- "elevation"
epw$time_step
epw$time_step <- "time_step"
epw$start_day_of_week
epw$start_day_of_week <- "start_day_of_week"

epw$path()
epw$get_data(year = NULL, unit = FALSE, tz = Sys.timezone(), update = FALSE)
epw$set_data(data)

epw$save(path, overwrite = FALSE)

epw$print()
print(epw)
}
}

\section{Read}{
\preformatted{epw <- read_epw(path)
}

\strong{Arguments}
\itemize{
\item \code{path}: Path of an EnergyPlus \code{EPW} file.
}

\preformatted{epw$save(path, overwrite = FALSE)
}

\strong{Arguments}
\itemize{
\item \code{path}: A path where to save the weather file. If \code{NULL}, the path of the
weather file itself will be used. Default: \code{NULL}.
\item \code{overwrite}: Whether to overwrite the file if it already exists. Default is
\code{FALSE}.
}
}

\section{Query and Modify Header}{
\preformatted{epw$city
epw$city <- "city"
epw$state_province
epw$state_province <- "state_province"
epw$country
epw$country <- "country"
epw$data_source
epw$data_source <- "data_source"
epw$wmo_number
epw$wmo_number <- "wmo_number"
epw$latitude
epw$latitude <- "latitude"
epw$longitute
epw$longitute <- "longitute"
epw$time_zone
epw$time_zone <- "time_zone"
epw$elevation
epw$elevation <- "elevation"
epw$time_step
epw$time_step <- "time_step"
epw$start_day_of_week
epw$start_day_of_week <- "start_day_of_week"
}

\code{$city}, \code{$state_province}, \code{$country}, \code{$data_source}, \code{$wmo_number},
\code{$latitude}, \code{$longitute}, \code{$time_zone}, \code{$elevation}, \code{$time_step} and
\code{$start_day_of_week} are all active bindings, which means that you can get
the value and also set new value to it.
}

\section{Query and Modify Data}{
\preformatted{epw$path()
epw$get_data(year = NULL, unit = FALSE, tz = Sys.timezone(), update = FALSE)
epw$set_data(data)
}

\code{$path} returns the path of EPW file.

\code{$get_data} returns the core weather data.

\code{$set_data} replaces core weather data with input data. NOTE: This feature is
experimental. There is no validation when replacing.

\strong{NOTE}: Even though \code{Epw} class provides methods to replace core weather data,
it is still not recommended.

\strong{Arguments}
\itemize{
\item \code{year}: A integer to indicate the year value in the return \code{datetime} column.
If \code{NULL}, the year will be left as it is in EPW file.
\item \code{tz}: The time zone of Date and Time in \code{datetime} column.
\item \code{unit}: If \code{TRUE}, units will be set to all numeric columns using
\code{\link[units:set_units]{units::set_units()}}.
\item \code{update}: If \code{TRUE}, not only \code{datetime} column, but also \code{year}, \code{month},
\code{day}, \code{hour} and \code{minute} will also be updated according to the input
\code{year} value.
\item \code{data}: A data.frame which has all required columns.
}
}

\author{
Hongyuan Jia
}
