% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduler.R
\name{detect_loop}
\alias{detect_loop}
\title{Runs the detect loop}
\usage{
detect_loop(data_dir = NA)
}
\arguments{
\item{data_dir}{Path to the 'data directory' containing application settings, models and collected tweets.
If not provided the system will try to reuse the existing one from last session call of \code{\link{setup_config}} or use the EPI_HOME environment variable, default: NA}
}
\value{
nothing
}
\description{
Infinite loop ensuring the daily signal detection and email alerts
}
\details{
The detect loop is composed of three 'one shot tasks' \code{\link{download_dependencies}}, \code{\link{update_geonames}}, \code{\link{update_languages}} ensuring the system has
all necessary components and data to run the three recurrent tasks \code{\link{generate_alerts}}

The loop report progress on the 'tasks.json' file which is read or created by this function.

The recurrent tasks are scheduled to be executed each 'detect span' minutes, which is a parameter set on the Shiny app.

If any of these tasks fails it will be retried three times before going to abort status. Aborted tasks can be relaunched from the Shiny app.
}
\examples{
if(FALSE){
   #Running the detect loop
   library(epitweetr)
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   detect_loop()
}
}
\seealso{
\code{\link{download_dependencies}}

 \code{\link{update_geonames}}

 \code{\link{update_languages}}

 \code{\link{detect_loop}}
 
 \code{\link{generate_alerts}}

 \code{\link{get_tasks}}
}
