% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{pairs.epimodel}
\alias{pairs.epimodel}
\title{Pairs method for epimodel objects}
\usage{
\method{pairs}{epimodel}(
  x,
  pars = NULL,
  regex_pars = NULL,
  par_models = NULL,
  par_types = NULL,
  par_groups = NULL,
  condition = pairs_condition(nuts = "accept_stat__"),
  ...
)
}
\arguments{
\item{x}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{pars}{A character vector giving parameter names.}

\item{regex_pars}{A character vector of regular expressions to select parameters.
If pars is also used, regex_pars is used in conjunction with pars.}

\item{par_models}{A character vector that restricts parameters to a subset of
model components. For example, "R" only uses parameters in the transmission model,
"inf" uses parameters in infection model. Strings giving the name of the
response in an observation model (i.e. LHS of the \code{formula} in \code{epiobs})
can also be used. If NULL (the default), all components are used.}

\item{par_types}{A character vector that restricts parameters based on their
type. The vector can include any of "fixed", "autocor", "random", "aux", "latent",
or "seeds". The default is c("fixed", "aux", "seeds"), to avoid printing a
very large number of parameters. If NULL, all types are used.}

\item{par_groups}{A character vector restricting parameters to those
used for a subset of regions in which the epidemic is modeled. Defaults to
NULL in which case all regions are used.}

\item{condition}{Same as \code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}},
except that the default is \code{accept_stat__}, as in \code{\link[rstanarm]{pairs.stanreg}}.
Please see the documentation for \code{\link[rstanarm]{pairs.stanreg}} for more
details on this default.}

\item{...}{Arguments passed to \code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.
The arguments \code{np}, \code{lp}, and \code{max_treedepth} are automatically
handled, and therefore do not need to be specified.}
}
\value{
Multiple \code{ggplot} objects in a grid using \code{\link[bayesplot]{bayesplot_grid}}.
}
\description{
Interface to \pkg{bayesplot}'s
\code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}} function. Closely
mirrors the functionality of \code{\link[rstanarm]{pairs.stanreg}}. Remember
not to specify too many paramaters. They will render slowly, and be difficult
to interpret.
}
