% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annual-wages-by-wage-group.R
\name{get_annual_wages_by_wage_group}
\alias{get_annual_wages_by_wage_group}
\title{Annual wages by wage group}
\usage{
get_annual_wages_by_wage_group()
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
Return the average annual salaries for select wage groups, with particular focus on
the highest wage earners. Note that this data is not directly comparable to wage
deciles/percentiles.
}
\details{
Wages are in 2017 dollars. Population sample: All workers.

The average annual wages by wage group are taken from a 2010 article by Wojciech Kopczuk,
Emmanuel Saez, and Jae Song. To extend this series, data for 2006 through 2017 are
extrapolated from 2004 data using changes in wage shares computed from Social Security
Administration wage statistics. We employ the midpoint of the bracket to compute total
wage income in each bracket and sum all brackets. We then use interpolation to derive
percentile cutoffs building from the bottom up to obtain the 0–90th percentile bracket
and then estimate the remaining categories. This allows us to estimate the wage shares
for upper wage groups. We use these wage shares computed for 2004 and later years to
extend the Kopczuk, Saez, and Song series by adding the changes in share between 2004
and the relevant year to their series. To obtain absolute wage trends we use the SSA data
on the total wage pool and employment and compute the real wage per worker (based on t
heir share of wages and employment) in the different groups in 2017 dollars. For a
detailed explanation, see the methodology for annual wages and hours.
}
\note{
Data source: SSA | Kopczuk, Saez, and Song (2010)
}
\examples{
get_annual_wages_by_wage_group()
}
\references{
\href{https://www.epi.org/data/}{Economic Policy Institute Data Library}
}
