% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmzrt.R
\name{getdoe}
\alias{getdoe}
\title{Filter the data based on DoE, rsd, intensity}
\usage{
getdoe(
  list,
  inscf = 5,
  rsdcf = 100,
  rsdcft = 30,
  imputation = "l",
  tr = F,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{list}{list with data as peaks list, mz, rt and group information}

\item{inscf}{Log intensity cutoff for peaks across samples. If any peaks show a intensity higher than the cutoff in any samples, this peaks would not be filtered. default 5}

\item{rsdcf}{the rsd cutoff of all peaks in all group}

\item{rsdcft}{the rsd cutoff of all peaks in technical replicates}

\item{imputation}{parameters for `getimputation` function method}

\item{tr}{logical. TRUE means dataset with technical replicates at the base level folder}

\item{BPPARAM}{An optional BiocParallelParam instance determining the parallel back-end to be used during evaluation.}
}
\value{
list with group mean, standard deviation, and relative standard deviation for all peaks, and filtered peaks index
}
\description{
Filter the data based on DoE, rsd, intensity
}
\examples{
data(list)
getdoe(list)
}
\seealso{
\code{\link{getdata2}},\code{\link{getdata}}, \code{\link{getmzrt}}, \code{\link{getimputation}}, \code{\link{getmr}},\code{\link{getpower}}
}
