% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signifig.R
\name{signifig}
\alias{signifig}
\title{Print significant figures}
\usage{
signifig(mean, error, data, signif.na = 2, style = "pm")
}
\arguments{
\item{mean}{a numeric vector or data frame object containing the averaged
values.}

\item{error}{a numeric vector or data frame object containing the respective
error terms.}

\item{data}{a data frame containing the specified columns. If empty,
\code{mean} and \code{error} need to be given as numeric vectors.}

\item{signif.na}{an integer controlling to which significant digit the mean
value should be rounded when no error data was given.}

\item{style}{a string specifying the output style to be used. The default
style \code{"pm"} reports the results as "3 ± 6", while \code{"par"} results
in outputs like "0.26 (0.02)". "siunitx" returns "0.26 (2)" which might be
used together with xtable for automated LaTeX table outputs.}
}
\description{
This function reports the significant figures of a given \code{mean} together
with its respective \code{error} term (for instance confidence interval or
standard deviation).
}
\examples{
signifig(mean = c(0.28,5), error = c(0.688, 8))

}
\references{
Taylor, J.R. (1997). \emph{Error analysis: the study of uncertainties in physical
measurements}. University Science Books, Sausalito, CA.
}
\author{
Zacharias Steinmetz
}
