% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemblQueryLDregionEndpoint.R
\name{ensemblQueryLDwithSNPregion}
\alias{ensemblQueryLDwithSNPregion}
\title{Function to query Ensembl LD data within a genomic window to get all variant pairs in the specified region and associated LD metrics.}
\usage{
ensemblQueryLDwithSNPregion(chr, start, end, pop = "1000GENOMES:phase_3:EUR")
}
\arguments{
\item{chr}{String. Chromosome that the query region is located on.}

\item{start}{String. Base pair that the query region starts at.}

\item{end}{String. Base pair that the query region ends at.}

\item{pop}{String. Population for which to compute LD. Use `ensemblQueryGetPops()` to retrieve a list of all populations with LD data. Default is 1000GENOMES:phase_3:EUR.}
}
\value{
A dataframe.
}
\description{
Function to query Ensembl LD data within a genomic window to get all variant pairs in the specified region and associated LD metrics.
}
\examples{
ensemblQueryLDwithSNPregion(
chr="6",
start="25837556",
end="25843455",
pop="1000GENOMES:phase_3:EUR"
)

}
