% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enpls.fit.R
\name{enpls.fit}
\alias{enpls.fit}
\title{Ensemble Partial Least Squares Regression}
\usage{
enpls.fit(x, y, maxcomp = NULL, MCtimes = 500L, method = c("mc",
  "bootstrap"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{maxcomp}{Maximum number of components included within the models,
if not specified, default is the variable (column) numbers in x.}

\item{MCtimes}{times of Monte-Carlo}

\item{method}{\code{"mc"} or \code{"bootstrap"}. Default is \code{"mc"}.}

\item{ratio}{sample ratio used when \code{method = "mc"}}

\item{parallel}{Integer. Number of CPU cores to use.
Default is \code{1} (not parallelized).}
}
\value{
A list containing all partial least squares model objects.
}
\description{
Ensemble partial least squares regression.
}
\examples{
data("alkanes")
x = alkanes$x
y = alkanes$y

set.seed(42)
fit = enpls.fit(x, y, MCtimes = 50)
print(fit)
predict(fit, newx = x)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\references{
Dongsheng Cao, Yizeng Liang, Qingsong Xu, Yifeng Yun, and Hongdong Li.
"Toward better QSAR/QSPR modeling: simultaneous outlier detection and
variable selection using distribution of model features."
\emph{Journal of computer-aided molecular design} 25, no. 1 (2011): 67--80.
}
\seealso{
See \code{\link{enpls.fs}} for feature selection with ensemble
partial least squares regression.
See \code{\link{enpls.od}} for outlier detection with ensemble
partial least squares regression.
}

