% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc.R
\name{proc_enm}
\alias{proc_enm}
\title{Partial ROC calculation}
\usage{
proc_enm(test_prediction, prediction, threshold = 5, sample_percentage = 50,
         iterations = 500)
}
\arguments{
\item{test_prediction}{(numeric) vector of model predictions for testing
data.}

\item{prediction}{\code{SpatRaster} or numeric vector of model predictions to be
evaluated.}

\item{threshold}{(numeric) value from 0 to 100 to represent the percentage of
potential error (E) that the data could have due to any source of uncertainty.
Default = 5.}

\item{sample_percentage}{(numeric) percentage of testing data to be used in each
bootstrapped process for calculating the partial ROC. Default = 50.}

\item{iterations}{(numeric) number of bootstrap iterations to be performed;
default = 500.}
}
\value{
A list with the summary of the results and a data.frame containing
the AUC values and AUC ratios calculated for all iterations.
}
\description{
proc applies partial ROC tests to model predictions.
}
\details{
Partial ROC is calculated following Peterson et al. (2008)
\url{doi:10.1016/j.ecolmodel.2007.11.008}.
}
\examples{
# Loading a model prediction
pred <- terra::rast(system.file("extdata", "proj_out_wmean.tif",
                                package = "enmpa"))

# Simulated data
test <- runif(100, min = 0.3, max = 0.8)

# partial ROC calculation
pr <- proc_enm(test, pred, threshold = 5, sample_percentage = 50,
               iterations = 500)
}
