% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.r
\name{pvalue.crr}
\alias{pvalue.crr}
\title{Extracts p-value from a competing risk model}
\usage{
\method{pvalue}{crr}(x, log_p = FALSE, ...)
}
\arguments{
\item{x}{Fitted crr model, as returned by \code{\link[cmprsk]{crr}}.}

\item{log_p}{Whether to return the logarithm of the p-value.}

\item{...}{Ignored. Kept for S3 consistency.}
}
\value{
Two-sided p-value.
}
\description{
Extracts p-value from a competing risk model
}
\examples{
if(requireNamespace("cmprsk", quitely = TRUE)){

  time <- 1:20
  event <- c(rep(0, 9), rep(2, 3), rep(1, 8))
  data <- rep(0:1, each=10)
  x <- cmprsk::crr(time, event, data)

  # Compare p-values of implementations
  print(x)
  pvalue(x)

}
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{pvalue}}
}

