% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.emdi.R
\name{estimators}
\alias{estimators}
\title{Presents point, MSE and CV estimates}
\usage{
estimators(object, indicator, MSE, CV, ...)
}
\arguments{
\item{object}{an object for which point and/or MSE estimates and/or
calculated CV's are desired.}

\item{indicator}{optional character vector that selects which indicators
shall be returned: (i) all calculated indicators ("all");
(ii) each indicator name: "Mean" "Quantile_10", "Quantile_25", "Median",
"Quantile_75", "Quantile_90", "Head_Count", 
"Poverty_Gap", "Gini", "Quintile_Share" or the function name/s of 
"custom_indicator/s"; (iii) groups of indicators: "Quantiles", "Poverty", 
"Inequality" or "Custom".If two of these groups are selected, only the first
one is returned. Defaults to "all". Note, additional custom indicators can be 
defined as argument for model-based approaches (see also \code{\link{ebp}}) 
and do not appear in groups of indicators even though these might belong to 
one of the groups.}

\item{MSE}{optional logical. If \code{TRUE}, MSE estimates for selected indicators
per domain are added to the data frame of point estimates. Defaults to 
\code{FALSE}.}

\item{CV}{optional logical. If \code{TRUE}, coefficients of variation for selected
indicators per domain are added to the data frame of point estimates.
Defaults to \code{FALSE}.}

\item{...}{arguments to be passed to or from other methods, e.g. indicator.}
}
\value{
The return of \code{estimators} depends on the class of its argument. The
documentation of particular methods gives detailed information about the
return of that method.
}
\description{
Function \code{estimators} is a generic function used to present point and
mean squared error (MSE) estimates and calculated coefficients of variation
(CV).
}
