% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small.em.R
\name{small.em}
\alias{small.em}
\title{Carry out several short EM fits to test for optimal starting locations.}
\usage{
small.em(x, y, b.init = "fit", weight = c(1), K = 2, maxiter = 5,
  tol.1 = 1e-04, tol.2 = 1e-04, noise = 0.2, sample.size = 500,
  repeats = 5, debug = FALSE, family = "poisson",
  method = "numeric", maxiter.NR = 20)
}
\arguments{
\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{b.init}{The method to initialize EM parameters.  Built in methods are "random" and "fit" for pure white noise, and white noise around GLM estimates.  Alternatively, pass a list of length K, each element consisting of a vector of length \emph{p}.  Users can also pass a zero-argument function to produce starting states.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{K}{Number of EM classes to be fit.}

\item{maxiter}{Maximum number of re-weighting rounds to do in fitting the EM model.  Primarily used to perform the 'small.em' warm-up routine.}

\item{tol.1}{Escape tolerance of the Newton-Raphson step.}

\item{tol.2}{Escape tolerance of the re-weighting step.}

\item{noise}{Standard deviation of the white noise to be applied when generating random initial states.}

\item{sample.size}{Number of cases to randomly select from the input data.}

\item{repeats}{Number of repetitions of the initialization to make.}

\item{debug}{Returns step-size in NR and re-weighting steps as a message if TRUE.}

\item{family}{GLM family to fit.}

\item{method}{Control string.  Set to 'numeric' or 'pracma'.}

\item{maxiter.NR}{Maximum number of Newton-Raphson steps to take.}
}
\value{
A 'small.em' list containing the parameters, weights, log likelihood and BIC values.
}
\description{
Carry out several short EM fits to test for optimal starting locations.
}
\examples{
x <- model.matrix(~ factor(wool) + factor(tension), warpbreaks)
y <- warpbreaks$breaks

warm_up <- small.em(x = x, y = y, K = 2, b.init = "random", sample.size = 50)
summary(warm_up)

params <- select_best(warm_up)

m <- em.glm(x = x, y = y, K = 2, b.init = params)
summary(m)
}
