% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-vllm.R
\name{chat_vllm}
\alias{chat_vllm}
\alias{models_vllm}
\title{Chat with a model hosted by vLLM}
\usage{
chat_vllm(
  base_url,
  system_prompt = NULL,
  model,
  seed = NULL,
  api_args = list(),
  api_key = vllm_key(),
  echo = NULL
)

models_vllm(base_url, api_key = vllm_key())
}
\arguments{
\item{base_url}{The base URL to the endpoint; the default uses OpenAI.}

\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{model}{The model to use for the chat.
Use \code{models_vllm()} to see all options.}

\item{seed}{Optional integer seed that ChatGPT uses to try and make output
more reproducible.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Combined with the body object generated by ellmer
with \code{\link[=modifyList]{modifyList()}}.}

\item{api_key}{API key to use for authentication.

You generally should not supply this directly, but instead set the \code{VLLM_API_KEY} environment variable.
The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://docs.vllm.ai/en/latest/}{vLLM} is an open source library that
provides an efficient and convenient LLMs model server. You can use
\code{chat_vllm()} to connect to endpoints powered by vLLM.
}
\examples{
\dontrun{
chat <- chat_vllm("http://my-vllm.com")
chat$chat("Tell me three jokes about statisticians")
}
}
